function RM = F_Euler2matrix(Angle)
% input:the Euler angle. output:rotation matrix.
% For the same rotation result, the value of Euler angles depends on the 
% sequence of the rotation axis. In this code the sequence is Z-Y-Z,
% according to the https://www.continuummechanics.org/rotationmatrix.html.
% the order of the angles is psi-theta-phi
% The basis vector of the orientation is the transpose of RM.
Angle = Angle / 180 * pi;
[A,B,C] = deal(Angle(1),Angle(2),Angle(3)); 
RM = [cos(A)*cos(B)*cos(C)-sin(A)*sin(C),-1*cos(A)*cos(B)*sin(C)-sin(A)*cos(C),cos(A)*sin(B); ...
      sin(A)*cos(B)*cos(C)+cos(A)*sin(C),-1*sin(A)*cos(B)*sin(C)+cos(A)*cos(C),sin(A)*sin(B); ...
     -1*sin(B)*cos(C),sin(B)*sin(C),cos(B)];