%00 Find the extreme Hydrostatic stress with respect to GB inclination angle.
tic
N = 500000;
RM_standard = [1 0 0;0 1 0;0 0 1]';
%[C11,C12,C44] = deal(514.8,201.3,157.5); % W
%[C11,C12,C44] = deal(106.3,60.5,28.3); % Al
%[C11,C12,C44] = deal(464.2,174.4,111.1); % Mo
% [C11,C12,C44] = deal(345.5,65.4,100.2); % Cr
% [C11,C12,C44] = deal(230.7,120.5,43.1); % V
%[C11,C12,C44] = deal(164.8,63.8,79.4); % Si
%[C11,C12,C44] = deal(229.3,134.1,116.7); % Fe
%[C11,C12,C44] = deal(13.8,11.6,9.6); % Li
[C11,C12,C44] = deal(170.2,123.2,75.2); % Cu
%[C11,C12,C44] = deal(ElasticComponents(19,1),ElasticComponents(19,2),ElasticComponents(19,3));
[C_iron_tensor,~,~] = Tensor(C11,C12,C44);
S_tensor = Reverse(pinv(Transform9(C_iron_tensor)));

%C_tensor = AllElastic(:,:,2); % Ti
%C_tensor = AllElastic(:,:,3); % Zn
%C_tensor = AllElastic(:,:,1); % Mg
%S_tensor = Reverse(pinv(C_tensor));

S_standard = F_rotate_compliance_by_matrix(S_tensor,RM_standard);
s11 = S_standard(1,1);
s12 = S_standard(1,2);
s44 = S_standard(4,4);
chi = 2*s11 - 2*s12 - s44;
IFmax = (4*s11-4*s12-2*s44)/(10*s11+14*s12+s44);
List_All_IFmax = zeros(1,91);
for angle = 1:91
t1 = angle-1;
t2 = rand()*180;
Q = [sind(t2),0,cosd(t2);
    sind(t1)*cosd(t2),cosd(t1),-1*sind(t1)*sind(t2);
    -1*cosd(t1)*cosd(t2),sind(t1),sind(t2)*cosd(t1)];

V12 = generater();
V11 = generater();
V11 = (V11-dot(V11,V12)*V12);
V11 = V11/norm(V11);
V13 = cross(V11,V12);
RM1_GLOBAL = [V11;V12;V13];
RM1_GB = Q * RM1_GLOBAL;
V22 = generater();
V21 = generater();
V21 = (V21-dot(V21,V22)*V22);
V21 = V21/norm(V21);
V23 = cross(V21,V22);
RM2_GLOBAL = [V21;V22;V23];
RM2_GB = Q * RM2_GLOBAL;

IF_max = -100;

% S1 = F_rotate_compliance_by_matrix(S_tensor,RM1_GB);
% S2 = F_rotate_compliance_by_matrix(S_tensor,RM2_GB);
% Sigma_matrix = [1 0 0;0 1 0;0 0 1];
% S = Q * Sigma_matrix * Q';
% Sigma = [S(1,1);S(2,2);S(3,3);S(2,3);S(3,1);S(1,2)];

beta = 1.0;
Count = 0;
List_IFmax = [-10,-9];
for i = 1:N
    if Count == 100
        beta = beta*1.005;
        Count = 0;
    end
    type = randi([1,7]);
    Delta_V = [(rand()-0.5)*0.005,(rand()-0.5)*0.005,(rand()-0.5)*0.005];
    t2_ = t2;
    V11_ = V11;
    V12_ = V12;
    V21_ = V21;
    V22_ = V22;
    if type == 1
        Delta_t2 = (rand()-0.5)*1;
        t2_ = t2_ + Delta_t2;
    elseif type == 2
        V11_ = V11_ + Delta_V;
    elseif type == 3
        V12_ = V12_ + Delta_V;
    elseif type == 4
        V21_ = V21_ + Delta_V;
    elseif type == 5
        V22_ = V22_ + Delta_V;
    end

Q_ = [sind(t2_),0,cosd(t2_);
    sind(t1)*cosd(t2_),cosd(t1),-1*sind(t1)*sind(t2_);
    -1*cosd(t1)*cosd(t2_),sind(t1),sind(t2_)*cosd(t1)];
V12_ = V12_/norm(V12_);
V11_ = (V11_-dot(V11_,V12_)*V12_);
V11_ = V11_/norm(V11_);
V13_ = cross(V11_,V12_);
RM1_GLOBAL_ = [V11_;V12_;V13_];
RM1_GB_ = Q_ * RM1_GLOBAL_;

V22_ = V22_/norm(V22_);
V21_ = (V21_-dot(V21_,V22_)*V22_);
V21_ = V21_/norm(V21_);
V23_ = cross(V21_,V22_);
RM2_GLOBAL_ = [V21_;V22_;V23_];
RM2_GB_ = Q_ * RM2_GLOBAL_;

S1 = F_rotate_compliance_by_matrix(S_tensor,RM1_GB_);
S2 = F_rotate_compliance_by_matrix(S_tensor,RM2_GB_);
Sigma_matrix = [0 0 0;0 1 0;0 0 0];
S = Q * Sigma_matrix * Q';
Sigma = [S(1,1);S(2,2);S(3,3);S(2,3);S(3,1);S(1,2)];

[Stress1,Stress2,Strain1,Strain2] = F_IncStressStrain(Sigma,S1,S2);
DeltaStress = (Stress1 - Stress2)./2;
IF = abs(DeltaStress(1)+DeltaStress(3));

if rand() < exp(beta*(IF - IF_max))
    Count = Count+1;
    t2 = t2_;
    V11 = V11_;
    V12 = V12_;
    V21 = V21_;
    V22 = V22_;
    IF_max = IF;
end
if rem(i,10000)==0
    List_IFmax = [List_IFmax, IF_max];
end
if abs(List_IFmax(end) - List_IFmax(end-1)) < 0.001
    i
    break
end

end
List_All_IFmax(angle) = IF_max;
end
toc