RM_standard = [1 0 0;0 1 0;0 0 1]';
[C11,C12,C44] = deal(229.3,134.1,116.7); % Fe
%[C11,C12,C44] = deal(170.2,123.2,75.2); %Cu
%[C11,C12,C44] = deal(13.8,11.6,9.6); %Li
[C_iron_tensor,~,~] = Tensor(C11,C12,C44);
S_tensor = Reverse(pinv(Transform9(C_iron_tensor)));
S_standard = F_rotate_compliance_by_matrix(S_tensor,RM_standard);
s11 = S_standard(1,1);
s12 = S_standard(1,2);
s44 = S_standard(4,4);
chi = 2*s11 - 2*s12 - s44;
IFmax = (4*s11-4*s12-2*s44)/(10*s11+14*s12+s44);

V2 = generater();
V1 = generater();
V1 = (V1-dot(V1,V2)*V2);
V1 = V1/norm(V1);
V3 = cross(V1,V2);
RM1 = [V1;V2;V3];
S1_ = F_rotate_compliance_by_matrix_Tensor(S_tensor,RM1);
V2 = generater();
V1 = generater();
V1 = (V1-dot(V1,V2)*V2);
V1 = V1/norm(V1);
V3 = cross(V1,V2);
RM2 = [V1;V2;V3];
S2_ = F_rotate_compliance_by_matrix_Tensor(S_tensor,RM2);
% 
% S1 = F_rotate_compliance_by_matrix(S_tensor,RM1);
% S2 = F_rotate_compliance_by_matrix(S_tensor,RM2);

S = [rand()-0.5,rand()-0.5,rand()-0.5,rand()-0.5,rand()-0.5,rand()-0.5];
Sigma_matrix = [S(1),S(6),S(5);S(6),S(2),S(4);S(5),S(4),S(3)];
for j = 1:361
Theta = j-1;
RM = F_RotateAroundAxis(Theta,[0;1;0]);

RM1_GB_ = RM * RM1;
RM2_GB_ = RM * RM2;
Sigma_matrix_p = RM * Sigma_matrix * RM';
Sigma = [Sigma_matrix_p(1,1);Sigma_matrix_p(2,2);Sigma_matrix_p(3,3);
    Sigma_matrix_p(2,3);Sigma_matrix_p(3,1);Sigma_matrix_p(1,2)];
%Sigma(1)+Sigma(3)
S1 = F_rotate_compliance_by_matrix(S1_,RM);
S2 = F_rotate_compliance_by_matrix(S2_,RM);
[Stress1,Stress2,Strain1,Strain2] = F_IncStressStrain(Sigma,S1,S2);
DeltaStress = Stress1 - Stress2;
IS(j,:) = [DeltaStress(1),DeltaStress(3),DeltaStress(5),0.5*(DeltaStress(1)+DeltaStress(3))];
end

scatter(IS(:,1),IS(:,3))
hold on
scatter(IS(:,2),-1.*IS(:,3))
axis equal