%00 Find the extreme Hydrostatic stress with respect to GB inclination angle.
tic
N = 50000;
Ele = 1;
W_91_50000 = zeros(91,N,4);
RM_standard = [1 0 0;0 1 0;0 0 1]';
%[C11,C12,C44] = deal(514.8,201.3,157.5); % W
%[C11,C12,C44] = deal(106.3,60.5,28.3); % Al
%[C11,C12,C44] = deal(464.2,174.4,111.1); % Mo
% [C11,C12,C44] = deal(345.5,65.4,100.2); % Cr
% [C11,C12,C44] = deal(230.7,120.5,43.1); % V
%[C11,C12,C44] = deal(164.8,63.8,79.4); % Si
%[C11,C12,C44] = deal(229.3,134.1,116.7); % Fe
%[C11,C12,C44] = deal(13.8,11.6,9.6); % Li
%[C11,C12,C44] = deal(170.2,123.2,75.2); % Cu
[C11,C12,C44] = deal(ElasticComponents(Ele,1),ElasticComponents(Ele,2),ElasticComponents(Ele,3));
[C_iron_tensor,~,~] = Tensor(C11,C12,C44);
S_tensor = Reverse(pinv(Transform9(C_iron_tensor)));
S_standard = F_rotate_compliance_by_matrix(S_tensor,RM_standard);
s11 = S_standard(1,1);
s12 = S_standard(1,2);
s44 = S_standard(4,4);
chi = 2*s11 - 2*s12 - s44;
IFmax = (4*s11-4*s12-2*s44)/(10*s11+14*s12+s44);
parfor theta1 = 1:91
    t1 = theta1 - 1;
for i = 1:N
t2 = rand()*180;
Q = [sind(t2),0,cosd(t2);
    sind(t1)*cosd(t2),cosd(t1),-1*sind(t1)*sind(t2);
    -1*cosd(t1)*cosd(t2),sind(t1),sind(t2)*cosd(t1)];
V2 = generater();
V1 = generater();
V1 = (V1-dot(V1,V2)*V2);
V1 = V1/norm(V1);
V3 = cross(V1,V2);
RM1_GLOBAL = [V1;V2;V3];
RM1_GB = RM1_GLOBAL * Q';
V2 = generater();
V1 = generater();
V1 = (V1-dot(V1,V2)*V2);
V1 = V1/norm(V1);
V3 = cross(V1,V2);
RM2_GLOBAL = [V1;V2;V3];
RM2_GB = RM2_GLOBAL * Q';


S1 = F_rotate_compliance_by_matrix(S_tensor,RM1_GB);
S2 = F_rotate_compliance_by_matrix(S_tensor,RM2_GB);
Sigma_matrix = [0 0 0;0 1 0;0 0 0];
S = Q * Sigma_matrix * Q';
Sigma = [S(1,1);S(2,2);S(3,3);S(2,3);S(3,1);S(1,2)];
%Sigma = [0;cosd(t1)^2;sind(t1)^2;sind(t1)*cosd(t1);0;0];

[Stress1,Stress2,Strain1,Strain2] = F_IncStressStrain(Sigma,S1,S2);
DeltaStress = (Stress1 - Stress2)./2;
IF = DeltaStress(1)+DeltaStress(3);
H1 = (Stress1(1)+Stress1(2)+Stress1(3))/3;
H2 = (Stress2(1)+Stress2(2)+Stress2(3))/3;

W_91_50000(theta1,i,:) = [t1,IF,H1,H2];
end
end
toc

W_ = [];
for i = 1:91
All = W_91_50000(i,:,2);
W_ = [W_,max(All)];
end