%00 Find the extreme Hydrostatic stress with respect to GB inclination angle.
tic
RM_standard = [1 0 0;0 1 0;0 0 1]';
%[C11,C12,C44] = deal(514.8,201.3,157.5); % W
%[C11,C12,C44] = deal(106.3,60.5,28.3); % Al
%[C11,C12,C44] = deal(464.2,174.4,111.1); % Mo
% [C11,C12,C44] = deal(345.5,65.4,100.2); % Cr
% [C11,C12,C44] = deal(230.7,120.5,43.1); % V
%[C11,C12,C44] = deal(164.8,63.8,79.4); % Si
[C11,C12,C44] = deal(229.3,134.1,116.7); % Fe
%[C11,C12,C44] = deal(13.8,11.6,9.6); % Li
%[C11,C12,C44] = deal(170.2,123.2,75.2); % Cu
%[C11,C12,C44] = deal(ElasticComponents(19,1),ElasticComponents(19,2),ElasticComponents(19,3));
[C_tensor,~,~] = Tensor(C11,C12,C44);
S_tensor = Reverse(pinv(Transform9(C_tensor)));
S_standard = F_rotate_compliance_by_matrix(S_tensor,RM_standard);
s11 = S_standard(1,1);
s12 = S_standard(1,2);
s44 = S_standard(4,4);
chi = 2*s11 - 2*s12 - s44;
IFmax = (4*s11-4*s12-2*s44)/(10*s11+14*s12+s44);

% V2 = [-1 3 2];
% V2 = V2/norm(V2);
% V1 = generater();
% V1 = (V1-dot(V1,V2)*V2);
% V1 = V1/norm(V1);
% V3 = cross(V1,V2);
% RM1_GLOBAL = [V1;V2;V3];
% 
% V2 = [1 2 0];
% V2 = V2/norm(V2);
% V1 = generater();
% V1 = (V1-dot(V1,V2)*V2);
% V1 = V1/norm(V1);
% V3 = cross(V1,V2);
% RM2_GLOBAL = [V1;V2;V3];
RM1_GLOBAL = [1 0 0;0 1 0;0 0 1;];
V2 = [1 1 1];
V2 = V2/norm(V2);
V1 = [1 -1 0];
V1 = (V1-dot(V1,V2)*V2);
V1 = V1/norm(V1);
V3 = cross(V1,V2);
RM2_GLOBAL = [V1;V2;V3];
%OP_multi = zeros(91,100,2);
for theta1 = 1:90
t1 = theta1 - 1;
for phi = 1:1000
t2 = rand()*180;
Q = [sind(t2),0,cosd(t2);
    sind(t1)*cosd(t2),cosd(t1),-1*sind(t1)*sind(t2);
    -1*cosd(t1)*cosd(t2),sind(t1),sind(t2)*cosd(t1)];

RM1_GB = Q * RM1_GLOBAL;
RM2_GB = Q * RM2_GLOBAL;

S1 = F_rotate_compliance_by_matrix(S_tensor,RM1_GB);
S2 = F_rotate_compliance_by_matrix(S_tensor,RM2_GB);
Sigma_matrix = [0 0 0;0 1 0;0 0 0];
S = Q * Sigma_matrix * Q';
Sigma = [S(1,1);S(2,2);S(3,3);S(2,3);S(3,1);S(1,2)];
%Sigma = [0;cosd(t1)^2;sind(t1)^2;sind(t1)*cosd(t1);0;0];

[Stress1,Stress2,Strain1,Strain2] = F_IncStressStrain(Sigma,S1,S2);
DeltaStress = (Stress1 - Stress2)./2;
IF = abs(DeltaStress(1)+DeltaStress(3));

%OP_multi(theta1,phi,:) = [t1,IF]; % Theta, IF, hydrostatic 1, 2
output(theta1,phi) = IF;
end
end
toc
for i=1:90
IF_MAX(i) = max(output(i,:));
IF_MIN(i) = min(output(i,:));
end
plot(IF_MAX)
hold on
plot(IF_MIN)
% MAX_theta = [];
% for i = 1:2
% maxIF = max(OP_multi(i,:,2));
% MAX_theta(i) = maxIF;
% end
% X1= OP_multi(:,:,1);
% X2 = OP_multi(:,:,2);