%% This script is to find the most extreme incompatibility stress for heterogeneous GBs.
% FE for Ferrite ID = 1, CE for Cementite, ID = 2. INC = Stress2 - Stress1

% Elastic components are stored in ListForTrial.
% The output are 3-dimensional matrix.
Count = 5000;
datestr(now)
OrientationAll = zeros(Count,12);
Set = 3;
for Index = 1:1:Count
    [V1_1,V1_2,V1_3] = F_base_vectors();
    RM1 = [V1_1;V1_2;V1_3]';
    [V2_1,V2_2,V2_3] = F_base_vectors();
    RM2 = [V2_1;V2_2;V2_3]';
    
    %det(RM1)
    %det(RM2)
    %YM_main = zeros(Count,2,Set);
    parfor i = 1:91
        
        for j = 1:181
            
            Sigma_inc = zeros(6,Set);
            Angle1 = i - 1;
            Angle2 = j - 1;
            % Angle1 is the angle between norm of GB and direction of external stress (Y).
            % Angle2 is the angle between the projection of the vector on XZ plane and
            % direction of external stress (Y).
            % [C11,C12,C44] = deal(168.4,121.4,75.4);
            V_G1 = [sind(Angle1)*cosd(Angle2) cosd(Angle1) -sind(Angle1)*sind(Angle2)];
            % V_G1 is the norm of the GB plane.
            V_G2 = cross(V_G1,[0 1 0]);
            % V_G2 = [-0.7071 0.7071 0];
            V_G1 = V_G1/norm(V_G1);
            V_G2 = V_G2 - dot(V_G1,V_G2)*V_G1;
            V_G2 = V_G2/norm(V_G2);
            V_G3 = cross(V_G2,V_G1);
            
            Q = [V_G2;V_G1;V_G3];
            % Why in such a sequence?
            Sigma_matrix = [0 0 0;0 -100 0;0 0 0];
            Sigma_local = Q * Sigma_matrix * Q';
            Sigma_E = [Sigma_local(1,1),Sigma_local(2,2),Sigma_local(3,3),Sigma_local(3,2),Sigma_local(3,1),Sigma_local(2,1)];
            % The external stress is converted into GB coordinate system.
            Sigma_Voigt = [Sigma_local(1,1),Sigma_local(2,2),Sigma_local(3,3),Sigma_local(3,2),Sigma_local(3,1),Sigma_local(2,1)]';
            for Num = 1:1:Set
                E = AllElastic(:,:,Num);
                S = Reverse(pinv(E));
                
                S_1_RQ = F_rotate_compliance_by_matrix_tilt(S,RM1,Q);
                S_2_RQ = F_rotate_compliance_by_matrix_tilt(S,RM2,Q);
                Sigma_inc(:,Num) =  F_mismatch_stress_compliance(Sigma_Voigt,S_1_RQ,S_2_RQ);
                
                
                
            end
            Sigma_E_T = repmat(Sigma_E',1,Set);
            Stress1 = Sigma_E_T + 0.5 * Sigma_inc;
            Stress2 = Sigma_E_T - 0.5 * Sigma_inc;
            for Num = 1:1:Set
                Mises1(i,j,Num) = Voigt2Mises(Stress1(:,Num));% Angle1*Angle2*Set
                Mises2(i,j,Num) = Voigt2Mises(Stress2(:,Num));
                hydrostatic1(i,j,Num) = (Stress1(1,Num)+Stress1(2,Num)+Stress1(3,Num))/3;
                hydrostatic2(i,j,Num) = (Stress2(1,Num)+Stress2(2,Num)+Stress2(3,Num))/3;
                
            end
        end
    end
    
    DeltaMises = Mises1 - Mises2;
    Deltahydrostatic = hydrostatic1 - hydrostatic2;
    
    MaxMises1 = max(Mises1,[],2);% 2 dimensional matrix, Angle1*Set
    MinMises1 = min(Mises1,[],2);
    MaxMises2 = max(Mises2,[],2);
    MinMises2 = min(Mises2,[],2);
    MaxHS1 = max(hydrostatic1,[],2);
    MinHS1 = min(hydrostatic1,[],2);
    MaxHS2 = max(hydrostatic2,[],2);
    MinHS2 = min(hydrostatic2,[],2);
    MaxDeltaMises = max(DeltaMises,[],2);
    MaxDeltaHS = max(Deltahydrostatic,[],2);
    
    Output(Index,:,:) = [MaxMises1(:)';MinMises1(:)';MaxMises2(:)';MinMises2(:)';MaxDeltaMises(:)'];
    HSoutput(Index,:,:) = [MaxHS1(:)';MinHS1(:)';MaxHS2(:)';MinHS2(:)';MaxDeltaHS(:)'];%Count*5Set*Angle1
    OrientationAll(Index,:) = [V1_1,V1_2,V2_1,V2_2];
    for Num = 1:1:Set
        E = AllElastic(:,:,Num);
        S = Reverse(pinv(E));
        S_1_R = F_rotate_compliance_by_matrix(S,RM1);
        S_2_R = F_rotate_compliance_by_matrix(S,RM2);
        YM1(Num) = F_YoungsComplianceTensor(S_1_R,[0 1 0]);
        YM2(Num) = F_YoungsComplianceTensor(S_2_R,[0 1 0]);       
    end
    YM_main(Index,:,:) = [YM1;YM2];
end
datestr(now)