function matrices = F_PTMorientation( Quat )
% F_PTMORIENTATION is to convert quaternions into rotation matrix.
[qx,qy,qz,qw] = deal(Quat(1),Quat(2),Quat(3),Quat(4));
matrices(1,1) = 1.0-2.0*(qy*qy + qz*qz);
matrices(1,2) = 2.0*(qx*qy - qw*qz);
matrices(1,3) = 2.0*(qx*qz + qw*qy);
matrices(2,1) = 2.0*(qx*qy + qw*qz);
matrices(2,2) = 1.0-2.0*(qx*qx + qz*qz);
matrices(2,3) = 2.0*(qy*qz - qw*qx);
matrices(3,1) = 2.0*(qx*qz - qw*qy);
matrices(3,2) = 2.0*(qy*qz + qw*qx);
matrices(3,3) = 1.0-2.0*(qx*qx + qy*qy);

end

