function [Sigma_inc,Rotation_matrix1,Rotation_matrix2] = F_mismatch_stress(Sigma,C11,C12,C44,Rotation_matrix1,Rotation_matrix2)
% In this calculation, the normal to the GB is Y, which is also the
% direction of applied stress.
%Sigma = [0 -100 0 0 0 0]'; %External stress, xx yy zz yz xz xy
[C_iron_tensor,~,~] = Tensor(C11,C12,C44);
S_tensor = Reverse(pinv(Transform9(C_iron_tensor)));
S_grain1 = F_rotate_compliance_by_matrix(S_tensor,Rotation_matrix1);
S_grain2 = F_rotate_compliance_by_matrix(S_tensor,Rotation_matrix2);
S_star = S_grain2 - S_grain1; 
Epsilon_star = S_star * Sigma;
% when the volume fraction of grain1 and grain2 are equal, S_star can be simplified like this. 
% It means the difference of the compliance tensor of the two grain.
S_mix = 0.5 * S_grain1 + 0.5* S_grain2;
G = zeros(6);
%According to the paper 10.1080/14786435.2014.984787 ,when external stress
%is along y direction, the yy,yz,xy component of GB stress would be zero.
%it should be modified when the direction of external stress changes. 
D = S_mix(1,1)*S_mix(3,5)*S_mix(3,5)+S_mix(3,3)*S_mix(1,5)*S_mix(1,5)+S_mix(5,5)*S_mix(1,3)*S_mix(1,3)- ...
    S_mix(1,1)*S_mix(3,3)*S_mix(5,5)-2*S_mix(1,3)*S_mix(1,5)*S_mix(3,5);
G(1,1) = (S_mix(3,3)*S_mix(5,5)-S_mix(3,5)*S_mix(3,5))/D;
G(1,3) = (S_mix(1,5)*S_mix(3,5)-S_mix(1,3)*S_mix(5,5))/D;
G(3,1) = G(1,3);
G(3,3) = (S_mix(1,1)*S_mix(5,5)-S_mix(1,5)*S_mix(1,5))/D;
G(1,5) = (S_mix(1,3)*S_mix(3,5)-S_mix(1,5)*S_mix(3,3))/D;
G(5,1) = G(1,5);
G(5,5) = (S_mix(1,1)*S_mix(3,3)-S_mix(1,3)*S_mix(1,3))/D;
G(3,5) = (S_mix(1,3)*S_mix(1,5)-S_mix(3,5)*S_mix(1,1))/D;
G(5,3) = G(3,5);
Sigma_inc = G * Epsilon_star;
%Sigma_inc = Sigma_grain2 - Sigma_grain1
%in Abaqus, Grain2 is labeled as TOP, and Grain1 is labeled as BOTTOM.