function Youngs = F_YoungsModulus(RotationMatrix,C11,C12,C44,TheAxis)
% This function is to calculate the Young's modulus along the given
% direction.
% The input RotationMatrix should be the transpose of the cosine matrix.
[C_iron_tensor,~,~] = Tensor(C11,C12,C44);
S_tensor = Reverse(pinv(Transform9(C_iron_tensor)));
S = F_rotate_compliance_by_matrix(S_tensor,[1 0 0;0 1 0;0 0 1]);
Orientation = (RotationMatrix'*TheAxis')';
Orientation = Orientation/norm(Orientation);
L1 = dot(Orientation,[1 0 0]);
L2 = dot(Orientation,[0 1 0]);
L3 = dot(Orientation,[0 0 1]);
ReciE = S(1,1)*L1^4+S(2,2)*L2^4+S(3,3)*L3^4 + ...
    (S(4,4)+2*S(2,3))*(L2^2*L3^2)+(S(5,5)+2*S(1,3))*(L1^2*L3^2)+(S(6,6)+2*S(1,2))*(L1^2*L2^2)+ ...
    2*((S(1,4)+S(5,6))*L1^2+S(2,4)*L2^2+S(3,4)*L3^2)*L2*L3+ ...
    2*((S(2,5)+S(4,6))*L2^2+S(1,5)*L1^2+S(3,5)*L3^2)*L1*L3+ ...
    2*((S(3,6)+S(4,5))*L3^2+S(1,6)*L1^2+S(2,6)*L2^2)*L1*L2;
Youngs = 1/ReciE;