function Sigma_inc = F_Syy(C11,C12,C44,E1,E2)
%F_SXX calculate the incompatibility stress induced by Sigma_xx with given
%Young's modulus and elastic components.

% First calculate compliance components.
s11 = (C11+C12)/(C11+2*C12)/(C11-C12);
s12 = -C12/(C11+2*C12)/(C11-C12);
se44 = 1/C44;

Sigma_inc = [0 0 0 0 0 0]';
ISzz = 6 * (1/E2 - 1/E1) / (10*s11+14*s12+se44);
ISxx = 6 * (1/E2 - 1/E1) / (10*s11+14*s12+se44);
Sigma_inc(1) = ISxx;
Sigma_inc(3) = ISzz;
end