function G=F_ShearModulus(RotationMatrix,C11,C12,C44,Axis1,Axis2)
% Based on Hayes1998
[C_iron_tensor,~,~] = Tensor(C11,C12,C44);
S_tensor = Reverse(pinv(Transform9(C_iron_tensor)));
S = F_rotate_compliance_by_matrix(S_tensor,[1 0 0;0 1 0;0 0 1]);
Orientation1 = (RotationMatrix'*Axis1')';
O1 = Orientation1/norm(Orientation1);
Orientation2 = (RotationMatrix'*Axis2')';
O2 = Orientation2/norm(Orientation2);
ReciG = S(4,4)+2*(2*S(1,1)-2*S(1,2)-S(4,4))*(O1(1)^2*O2(1)^2+O1(2)^2*O2(2)^2+O1(3)^2*O2(3)^2);
G=1/ReciG;