function Q = F_InclinationAngle(Angle1,Angle2)
% Angle1 is the angle between norm of GB and direction of external stress (Y).
% Angle2 is the angle between the projection of the vector on XZ plane and
% direction of external stress (Y).
if Angle1 ~= 0
    V_G1 = [sind(Angle1)*cosd(Angle2) cosd(Angle1) -sind(Angle1)*sind(Angle2)];
    V_G2 = cross(V_G1,[0 1 0]);
    V_G1 = V_G1/norm(V_G1);
    V_G2 = V_G2 - dot(V_G1,V_G2)*V_G1;
    V_G2 = V_G2/norm(V_G2);
    V_G3 = cross(V_G2,V_G1);

    % V_G is the norm of the GB plane.
    Q = [V_G2;V_G1;V_G3];
else
    Q = [1 0 0;0 1 0;0 0 1];
end
end

