function [Stress1,Stress2,Strain1,Strain2] = F_IncStressStrain_TJ(Sigma,S1,S2)
C1 = pinv(S1);
C2 = pinv(S2);
M = zeros(24,24);

M(1:6,1:6) = C1;
M(7:12,7:12) = C2;
Left = -1 * eye(12,12);
M(1:12,13:24) = Left;
% C * strain = stress

M(13,1) = 1;
M(13,7) = -1;
M(14,3) = 1;
M(14,9) = -1;
M(15,5) = 1;
M(15,11) = -1;
% Strain 11, 33, 13 are equal for the two grains.

M(16,14) = 1;
M(17,20) = 1;
M(18,16) = 1;
M(19,22) = 1;
M(20,18) = 1;
M(21,24) = 1;
% Sigma 22, 23, 21, are known.

% M(22,13) = 1;
% M(22,19) = 1;
M(22,1) = 1;
M(23,15) = 1;
M(23,21) = 1;
M(24,17) = 1;
M(24,23) = 1;
% sum of Sigma 11, 33, 13 = 2 * Sigma_E. 

N = zeros(24,1);
N(16) = Sigma(2);
N(17) = Sigma(2);
N(18) = Sigma(4);
N(19) = Sigma(4);
N(20) = Sigma(6);
N(21) = Sigma(6);
N(22) = 2 * Sigma(1);
N(23) = 2 * Sigma(3);
N(24) = 2 * Sigma(5);


S = pinv(M) * N;
Strain1 = S(1:6);
Strain2 = S(7:12);
Stress1 = S(13:18);
Stress2 = S(19:24);
end

