function [Stress1,Stress2,Mises1,Mises2,Hydrostatic1,Hydrostatic2]=F_DirectMisesMatrix(RM1,RM2,C11,C12,C44)
% load('/home/kailiu/Documents/Incompatibility stress/FromIncompatibilityStressToStrain.mat')
% load('/home/kailiu/Documents/Incompatibility stress/Constant.mat')
% There are 24 variables, 6 for stress and 6 for strain for each grain.
% Equations:    1~12: s=C:e
%               13~15: e11, e33, e13 continue at GB
%               16~18: s22,s12,s23 same for a,b
%               19~21: s22=s_External, s12,s23=0.
%               22~24: ratio of s11,s33; s13 symmetry
% This solution is not proved to be precise. So, stop using it.
% Also refered as method B.
[C_iron_tensor,~,~] = Tensor(C11,C12,C44);
S_tensor = Reverse(pinv(Transform9(C_iron_tensor)));
Rotation_matrix1 = RM1;
Rotation_matrix2 = RM2;
[VTS,~] = F_rotate_compliance_by_matrix(S_tensor,Rotation_matrix1);
VTC = pinv(VTS);
[VBS,~] = F_rotate_compliance_by_matrix(S_tensor,Rotation_matrix2);
VBC = pinv(VBS);
Sigma_e= [0 -100 0 0 0 0]';
Elastic1=VBC;
Elastic2=VTC;
S_inc=Sigma_e(2);
ET11=F_YoungsModulus(Rotation_matrix1,237,141,116,[1 0 0]);
ET33=F_YoungsModulus(Rotation_matrix1,237,141,116,[0 0 1]);
EB11=F_YoungsModulus(Rotation_matrix2,237,141,116,[1 0 0]);
EB33=F_YoungsModulus(Rotation_matrix2,237,141,116,[0 0 1]);
MP_division3=MP;
MP_division3(16:24,:)=zeros(9,24);
Cons_division3=Constant;
MP_division3(1:6,1:6) = Elastic1;
MP_division3(7:12,7:12) = Elastic2;
MP_division3(16,14)=-1;MP_division3(16,20)=1;
MP_division3(17,16)=-1;MP_division3(17,22)=1;
MP_division3(18,18)=-1;MP_division3(18,24)=1;
MP_division3(19,14)=1;
MP_division3(20,16)=1;
MP_division3(21,18)=1;
MP_division3(22,13)=ET11;MP_division3(22,19)=EB11;
MP_division3(23,15)=ET33;MP_division3(23,21)=EB33;
MP_division3(24,17)=1;MP_division3(24,23)=1;
Cons_division3(16,1) = 0;
Cons_division3(17,1) = 0;
Cons_division3(18,1) = 0;
Cons_division3(19,1) = S_inc;
Cons_division3(20,1) = 0;
Cons_division3(21,1) = 0;

S_division3 = pinv(MP_division3) * Cons_division3;
Stress1 = S_division3(13:18);
Stress2 = S_division3(19:24);
Mises1 = Voigt2Mises(Stress1);
Mises2 = Voigt2Mises(Stress2);
Hydrostatic1 = (Stress1(1)+Stress1(2)+Stress1(3))/3;
Hydrostatic2 = (Stress2(1)+Stress2(2)+Stress2(3))/3;