clear all
load('/home/kailiu/Documents/MATLAB/main/Hexagonal/MgTiZn.mat')
C = AllElastic(:,:,3); %9*9   1:Mg, 2:Ti, 3:Zn
S_tensor = Reverse(pinv(C)); %4th order tensor
S = F_rotate_compliance_by_matrix(S_tensor,[1 0 0;0 1 0;0 0 1]); %6*6
Sigma = [0 1 0 0 0 0]';
for i = 1:50000
    [V11,V12,V13] = F_base_vectors();
    [V21,V22,V23] = F_base_vectors();
    RM1 = [V11;V12;V13]';
    RM2 = [V21;V22;V23]';
    Yaxis_1 = RM1(2,:);
    Yaxis_2 = RM2(2,:);
    Youngs1(i) = F_YoungsComplianceTensor(S,Yaxis_1);
    Youngs2(i) = F_YoungsComplianceTensor(S,Yaxis_2);
    S_1_R = F_rotate_compliance_by_matrix(S_tensor,RM1);
    S_2_R = F_rotate_compliance_by_matrix(S_tensor,RM2);
    [Stress1,Stress2,Strain1,Strain2] =  F_IncStressStrain(Sigma,S_1_R,S_2_R);
%     Sigma_inc =  F_mismatch_stress_compliance(Sigma,S_1_R,S_2_R);
    hydrostatic(i) = ((Stress2(1)+Stress2(2)+Stress2(3))/3 -(Stress1(1)+Stress1(2)+Stress1(3))/3)/2;
    IF(i) = (Stress1(1)+Stress1(3));% definiation of incompatibility factor
    Youngs(i) = 1/Youngs2(i) - 1/Youngs1(i); 
end
scatter(IF,Youngs)
hold on
% x = [-200,200];
% y = [-200,200];
% plot(x,y)
% xlabel('Analytical IF')
% ylabel('Prediction by Youngs modulus')
% title('IF for Mg')