%[C11,C12,C44] = deal(170.2,123.2,75.2); %Cu
%[C11,C12,C44] = deal(13.8,11.6,9.6); %Li
%[C11,C12,C44] = deal(106.3,60.5,28.3); %Al
[C11,C12,C44] = deal(229.3,134.1,116.7);%Fe
[C_iron_tensor,~,~] = Tensor(C11,C12,C44);
S_tensor = pinv(Transform9(C_iron_tensor));
s11 = S_tensor(1,1);
s12 = S_tensor(1,2);
s44 = S_tensor(4,4) * 4;
Count = 50000;
datestr(now)

Record = zeros(Count,2);
Sigma = [0 -1 0 0 0 0]';
for Index = 1:1:Count
[V1_1,V1_2,V1_3] = F_base_vectors();
Rotation_matrix_bottom = [V1_1;V1_2;V1_3]';
[V2_1,V2_2,V2_3] = F_base_vectors();
Rotation_matrix_top = [V2_1;V2_2;V2_3]';
YoungsYY_bottom = F_YoungsModulus(Rotation_matrix_bottom,C11,C12,C44,[0 1 0]);
YoungsYY_top = F_YoungsModulus(Rotation_matrix_top,C11,C12,C44,[0 1 0]);
[Sigma_inc,~,~] = F_mismatch_stress(Sigma,C11,C12,C44,Rotation_matrix_bottom,Rotation_matrix_top);
Delta = Sigma_inc(1)/2 + Sigma_inc(3)/2;
DeltaFromSimplifiedEquation = 6 * (1/YoungsYY_bottom - 1/YoungsYY_top) / (10*s11+14*s12+s44);
Record(Index,:) = [Delta,DeltaFromSimplifiedEquation];

end
scatter(Record(:,1),Record(:,2))