#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Sun Sep 17 17:57:12 2023

@author: kailiu
"""

import ovito, numpy
from ovito.data import *
from ovito.modifiers import *
import os
from tkinter import Tk     # from tkinter import Tk for Python 3.x
from tkinter.filedialog import askopenfilename
import numpy as np
from matplotlib import pyplot as plt


# Initialize an empty list to store the points
points = []

# Open and read the file
with open('Loc_R_Axis_Angle.txt', 'r') as file:
    for line in file:
        # Split each line into individual coordinates (assuming space-separated)
        coordinates = line.strip().split(',')
        
        # Convert the coordinates to float and append them to the points list
        point = [float(coord) for coord in coordinates]
        points.append(point)

def Particle(Loc, points, LX, LY, LZ):
    Dist_min = 10000000
    Label = 500
    for i in range(len(points)):
        Loc_node = points[i][:3]
        Loc_node = [round(X,3) for X in Loc_node]
        Vector = [x - y for x, y in zip(Loc_node, Loc)]
        Vector_min = [min(abs(Vector[0]),LX-abs(Vector[0])),min(abs(Vector[1]),LY-abs(Vector[1])),min(abs(Vector[2]),LZ-abs(Vector[2]))]
        Dist_sqrt = sum([x**2 for x in Vector_min])
        if Dist_sqrt <= Dist_min:
            Dist_min = Dist_sqrt
            Label = i
    return Label

Tk().withdraw() # we don't want a full GUI, so keep the root window from appearing
file_path = askopenfilename()
filename = file_path.split("/")[-1]
path=file_path.replace(filename, '')
os.chdir(path)
pipeline = ovito.io.import_file(filename)
data = pipeline.compute()
Num = data.particles.count
#Step = data.attributes['Timestep']
Position = data.particles['Position']
LX = data.cell[:,0][0]
LY = data.cell[:,1][1]
LZ = data.cell[:,2][2]

Particle_list = []
for i in range(100000):
    particle = Particle(Position[i][:3], points, LX, LY, LZ)
    Particle_list.append(particle)

