#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Aug 31 14:39:25 2023

@author: kailiu

This code is to generate lmp file for multiple Cu particles with PBC. Version 2.

Previous version can not generate high volume fraction models.
"""
import numpy as np
from math import ceil
import copy
from matplotlib import pyplot as plt
import random

def dist(Loc_1,Loc_2,BoxSize):
    Delta_x = min(abs(Loc_1[0]-Loc_2[0]),BoxSize[0]-abs(Loc_1[0]-Loc_2[0]))
    Delta_y = min(abs(Loc_1[1]-Loc_2[1]),BoxSize[1]-abs(Loc_1[1]-Loc_2[1]))
    Delta_z = min(abs(Loc_1[2]-Loc_2[2]),BoxSize[2]-abs(Loc_1[2]-Loc_2[2]))
    Vector = [Delta_x,Delta_y,Delta_z]
    dist = np.linalg.norm(Vector)
    return dist

#BoxSize = [1,1,1]
#Dist = []
#DeltaX = []
#DeltaY = []
#DeltaZ = []
#for i in range(0,100000):
#    Loc_1 = np.random.rand(3)
#    Loc_2 = np.random.rand(3)
#    Dist.append(dist(Loc_1,Loc_2,BoxSize)[0])
#    DeltaX.append(dist(Loc_1,Loc_2,BoxSize)[1])
#    DeltaY.append(dist(Loc_1,Loc_2,BoxSize)[2])
#    DeltaZ.append(dist(Loc_1,Loc_2,BoxSize)[3])
#print(max(Dist))
#print(max(DeltaX))
#print(max(DeltaY))
#print(max(DeltaZ))

Volume_Design = 0.25
BoxSize = [500,500,500]
Mean_R = 38.5
Std_R = 12.5
R_min = 15
R_max = 50

a = 3.615

List_Sphere = [] # X, Y, Z, R, rotation_axis(3), rotation angle
Loc_ini = np.dot(BoxSize,0.5)
R_ini = round(np.random.normal(Mean_R,Std_R,1)[0],2)
Axis_ini = np.random.rand(3)
Angle_ini = np.random.rand(1)*180
Initial = np.concatenate((Loc_ini,[R_ini],Axis_ini,Angle_ini))
volume = 4/3*np.pi*R_ini**3 / BoxSize[0] / BoxSize[1] / BoxSize[2]

List_Sphere.append(Initial.tolist())
R_list = []
R_list.append(R_ini) 
step = 0
while volume < Volume_Design:
    Loc_temp = BoxSize * np.random.rand(3)
    R_temp = -5
    step += 1
    while R_temp <= R_min or R_temp >= R_max:
        R_temp = round(np.random.normal(Mean_R,Std_R,1)[0],2)
    Count = 0
    for sphere in List_Sphere:
        Loc = sphere[0:3]
        R = sphere[3]
        Dist_temp = dist(Loc,Loc_temp,BoxSize)
        if Dist_temp < (R_temp + R):
            break
        else:
            Count += 1
    if Count ==  len(List_Sphere):
        Axis = np.random.rand(3)
        Angle = np.random.rand(1)*180
        List_Sphere.append(np.concatenate((Loc_temp, [R_temp], Axis, Angle)).tolist())
        R_list.append(R_temp)
        volume += 4/3*np.pi*R_temp**3 / BoxSize[0] / BoxSize[1] / BoxSize[2]
    if step%10000 == 0:
        print(volume)
        
for ID_Expansion in range(1000):        
    random_number = random.randint(0, len(R_list)-1)
    Dist_Min = 500
    for i in range(len(R_list)):
        if i != random_number:
            Dist_i = dist(List_Sphere[random_number][0:3],List_Sphere[i][0:3],BoxSize) - List_Sphere[random_number][3] - List_Sphere[i][3]
        else:
            Dist_i = 500
        Dist_Min = min(Dist_Min,Dist_i)

    R_list[random_number] += Dist_Min
    List_Sphere[random_number][3] += Dist_Min
Volume_final = sum([4 / 3 * np.pi * x**3 for x in R_list])
VF = Volume_final / BoxSize[0] / BoxSize[1] / BoxSize[2]
print(VF)
# for spheres that has R larger than min([X,Y,Z]), mirror spheres should be built. for X... then for Y...
# then for Z. therefore for worst situation, eight spheres will be built for one actual sphere.
print(len(List_Sphere))
MirrorX = []  
for sphere in List_Sphere:
        Loc = sphere[0:3]
        R = sphere[3]
        
        if Loc[0] < R:
            Xmirror = copy.deepcopy(sphere)
            Xmirror[0] += BoxSize[0]
            MirrorX.append(Xmirror)
        elif Loc[0] > (BoxSize[0]-R):
            Xmirror = copy.deepcopy(sphere)
            Xmirror[0] -= BoxSize[0]
            MirrorX.append(Xmirror)
List_Sphere += MirrorX
print(len(List_Sphere))
MirrorY = []
for sphere in List_Sphere:
        Loc = sphere[0:3]
        R = sphere[3]
        if Loc[1] < R:
            Ymirror = copy.deepcopy(sphere)
            Ymirror[1] += BoxSize[1]
            MirrorY.append(Ymirror)
        elif Loc[1] > (BoxSize[1]-R):
            Ymirror = copy.deepcopy(sphere)
            Ymirror[1] -= BoxSize[1]
            MirrorY.append(Ymirror)
List_Sphere += MirrorY
print(len(List_Sphere))
MirrorZ = [] 
for sphere in List_Sphere:
        Loc = sphere[0:3]
        R = sphere[3]        
        if Loc[2] < R:
            Zmirror = copy.deepcopy(sphere)
            Zmirror[2] += BoxSize[2]
            MirrorZ.append(Zmirror)
        elif Loc[2] > (BoxSize[2]-R):
            Zmirror = copy.deepcopy(sphere)
            Zmirror[2] -= BoxSize[2]
            MirrorZ.append(Zmirror)
List_Sphere += MirrorZ
print(len(List_Sphere))

f = open('Multi_particles_PBC.in', 'w')
f.write('units           metal \n')
f.write('boundary        p p p  \n')
f.write('atom_style  atomic \n')
f.write('neighbor        2.0 bin \n')
f.write('neigh_modify    every 1 delay 2 check yes\n')
f.write('region box block -100 ' + str(BoxSize[0]+100) + ' -100 ' +
        str(BoxSize[1]+100) + ' -100 '+str(BoxSize[2]+100) + ' units box\n' )
f.write('lattice fcc 3.615\n')
f.write('create_box     1 box\n')
f.write('pair_style eam/alloy\n')
f.write('pair_coeff * * Cu_mishin1.eam.alloy Cu\n')

for sphere in List_Sphere:
    R = sphere[3]
    Loc = sphere[0:3]
    Axis = sphere[4:7]
    Angle = sphere[7]
    f.write('region grain sphere ' +  str(Loc[0]) + ' ' +str(Loc[1]) + ' '+str(Loc[2]) + ' ' + str(R) +
            ' units box\n')
    f.write('create_atoms 1 region grain\n')
    f.write('group grain region grain\n')
    f.write('displace_atoms grain rotate ' +str(Loc[0]) + ' ' +str(Loc[1]) + ' '+str(Loc[2]) +
            ' '+ str(Axis[0])+ ' ' + str(Axis[1])+ ' ' +str(Axis[2])+ ' ' +
            str(Angle)+' units box\n')
    f.write('region grain delete\n group grain delete\n')

f.write('region xplus block ' + str(BoxSize[0]) + ' INF INF INF INF INF units box\n')
f.write('region xminus block INF 0 INF INF INF INF units box\n')
f.write('region yplus block INF INF ' + str(BoxSize[1]) + ' INF INF INF units box\n')
f.write('region yminus block INF INF INF 0 INF INF units box\n')
f.write('region zplus block INF INF INF INF ' + str(BoxSize[2]) + ' INF units box\n')
f.write('region zminus block INF INF INF INF INF 0 units box\n')
f.write('delete_atoms region xplus \n')
f.write('delete_atoms region xminus \n')
f.write('delete_atoms region yplus \n')
f.write('delete_atoms region yminus \n')
f.write('delete_atoms region zplus \n')
f.write('delete_atoms region zminus \n')
f.write('change_box all x final 0 ' + str(BoxSize[0]) + ' y final 0 ' + str(BoxSize[1]) +
        ' z final 0 ' + str(BoxSize[2]) + ' units box\n')
f.write('delete_atoms overlap 0.5 all all \n')
f.write('write_data model.atom')
f.close()

np.savetxt('Loc_R_Axis_Angle.txt', List_Sphere, delimiter=',')

plt.hist(R_list)
np.save('R_list.npy',R_list)







