%% FigSwidth
close all
clear all
clc

% wp = 259.7434;
% wp = 2.5974e+03;
% wp = 1.5585e+04;
wb = [25.974337734457 188.752733301635 618.562617361484 1348.93938563009 2369.6046474543 3682.0093709453 5286.05262251873 7181.74045955993 9369.07257922285 11848.0489815075];
wp = wb(5);
freq = logspace(0,log10(2*wp),1e3);
Kp = 0.25;
fig=figure('units','centimeters');
fig.Position = [1 1 19 5];
Smax = 20
for S = 1:Smax
% load(['k05S',num2str(S),'.mat'])
load(['k025w',num2str(5),'S',num2str(S),'.mat'])
% calculate static gain
M(:,S) = 20*log10(abs(freqresp(Ts(1,1),2*pi*freq)));
eg = unique(sort(abs(imag(eig(sminreal(Ts(1,1)))))/2/pi));
E{S} = eg;
L1(S) = eg(S);
L2(S) = eg(S+1);
end
% surface(1:10,freq,M-100)
% hold on
% imagesc([1 10],freq,M)
% hold on
splt=surface(1:Smax,2*pi/wp*freq,M)
% contour(1:Smax,2*pi/wp*freq,M)
% imagesc([1 Smax],[freq(1),freq(end)]*2*pi/wp,M)
hold on
c = colorbar;
c.Label.String = 'Transmissibility [dB]';
c.Label.Interpreter = "latex";
splt.EdgeColor = 'none';
%%
hold on
for S = 1:Smax
plot3(S*ones(size(E{S})),(E{S}/wp*2*pi),100*ones(size(E{S})),'ko','HandleVisibility','off')
% semilogy(S*ones(size(eig(sminreal(Ts(1,1))))),abs(imag(eig((sminreal(Ts(1,1))))))/2/pi,'ro','HandleVisibility','off')
leg{S} = ['N = ', num2str(round(S,0))];
end
plot3([0 Smax],1*[1 1], 100*[1 1],'--','linewidth',1.5,'Color','k','HandleVisibility','off')
hold on
plot3([0 Smax], 1*sqrt(1-Kp)*[1 1],100*[1 1],'--','linewidth',1.5,'Color','k','HandleVisibility','off')
plot3(1:Smax,L1/wp*2*pi,100*ones(Smax),'k-','LineWidth',1.5)
plot3(1:Smax,L2/wp*2*pi,100*ones(Smax),'k-','LineWidth',1.5)
% lgd = legend(['N = \infty',leg])

xlim([1,Smax]);
% ylim([2*pi*freq(1)/wp,2*pi*freq(end)/wp])
% ylim([2*pi*freq(1)/wp,1.4])
ylim([2*pi*freq(1)/wp,3])
ylabel('$\omega/\omega_t$','Interpreter','latex')
xlabel('S','Interpreter','latex')


% xlim([3 5])
% xlim([12 24])
% xlim([60 80])
%%
figure()
plot(1:Smax,L2-L1)