%% FigSpaBS1
clc
load('sysCtrlN10.mat')
% load('sysForce.mat')
H = c2d(sysCtrl,1e-4);
act = H.InputName;
sen = H.OutputName;
for n = 1:size(H,1)-1
H0(n,n) = real(freqresp(H(sen(n+1),act(n+1)),2*pi*2));
end
%% Target frequency
clr = parula(10);
close all
fig=figure('units','centimeters');
fig.Position = [1 1 19 15];
semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k')
hold on

freq = 2*pi*logspace(0,3,1e3);
wpRange = flip([2,4,8,16,32,64,128,256,512]);
for c = 1:length(wpRange)
wp =wpRange(c);
Kp = 2; % max gain 2.3
zp = 0.01;
clear PPF PPFd
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(sysCtrl('zout','zin'),freq)))),'linewidth',2,'Color','k')

for n = 1:size(H,1)-1
PPF(n,n) = inv(H0(n,n))*Kp*tf([1],[1/wp^2 2*zp/wp 1+Kp]);
% PPF(n,n) = inv(H0(n,n))*Kp*tf([1],[1/wp^2 2*zp/wp 1]);
PPFd(n,n) = c2d(PPF(n,n),1e-4,'tustin');
PPFd(n,n).InputName = sen(n+1);
PPFd(n,n).OutputName = act(n+1);
end
T = feedback(H,PPFd,1,'name');
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(T('zout','zin'),freq)))),'linewidth',2,'Color',clr(c,:))
semilogx(wpRange(c)/2/pi*[1 1],[-200 40],'--','linewidth',1,'Color',clr(c,:))
semilogx(wpRange(c)*sqrt(1+Kp/2)/2/pi*[1 1],[-200 40],'--','linewidth',1,'Color',clr(c,:))
end
ylabel('Transmissability $\left|{\ddot{y}}/{\ddot{w}_b}\right|$ [dB]','Interpreter','latex')
xlabel('Frequency [Hz]','Interpreter','latex')
xlim([1 1000])
% ylim([-40 40])
%% Gain
clr = parula(5);
close all
fig=figure('units','centimeters');
fig.Position = [1 1 19 15];
semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k','HandleVisibility','off')
hold on
semilogx(64*[1 1],[-40 40],'--','linewidth',1,'Color','k','HandleVisibility','off')
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H(1,1),freq)))),'linewidth',2,'Color','k')


freq = 2*pi*logspace(0,3,1e3);
kRange = logspace(-1,log10(5),5);
for c = 1:length(kRange)
wp = 2*pi*64;
Kp = kRange(c); % max gain 2.3
zp = 0.0;
clear PPF PPFd
for n = 1:size(H,1)-1
PPF(n,n) = inv(H0(n,n))*Kp*tf([1],[1/wp^2 2*zp/wp 1+Kp]);
PPFd(n,n) = c2d(PPF(n,n),1e-4,'tustin');
PPFd(n,n).InputName = sen(n+1);
PPFd(n,n).OutputName = act(n+1);
end
T = feedback(H,PPFd,1,'name');
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(T(1,1),freq)))),'linewidth',2,'Color',clr(c,:))
semilogx(64*sqrt(1+kRange(c)/2)*[1 1],[-40 40],'--','linewidth',1,'Color',clr(c,:),'HandleVisibility','off')
leg{c} = ['k = ', num2str(round(kRange(c),2))];
end
ylabel('Transmissability $\left|{\ddot{y}}/{\ddot{w}_b}\right|$ [dB]','Interpreter','latex')
xlabel('Frequency [Hz]','Interpreter','latex')
lgd = legend(['T',leg])
xlim([48 200])
ylim([-40 40])

%% Damping

clr = parula(12);
close all
fig=figure('units','centimeters');
fig.Position = [1 1 19 15];
semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k','HandleVisibility','off')
hold on
Kp = 1;
semilogx(64*[1 1],[-40 40],'--','linewidth',1,'Color','k','HandleVisibility','off')
semilogx(64*sqrt(1+Kp/2)*[1 1],[-40 40],'--','linewidth',1,'Color','k','HandleVisibility','off')
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H(1,1),freq)))),'linewidth',2,'Color','k')


freq = 2*pi*logspace(0,3,1e3);
zRange = 0:0.05:0.25;
for c = 1:length(zRange)
wp = 2*pi*64;
% Kp = 1; % max gain 2.3
zp = zRange(c);
clear PPF PPFd
for n = 1:size(H,1)-1
PPF(n,n) = inv(H0(n,n))*Kp*tf([1],[1/wp^2 2*zp/wp 1+Kp]);
PPFd(n,n) = c2d(PPF(n,n),1e-4,'tustin');
PPFd(n,n).InputName = sen(n+1);
PPFd(n,n).OutputName = act(n+1);
end
T = feedback(H,PPFd,1,'name');
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(T(1,1),freq)))),'linewidth',2,'Color',clr(c,:))
leg{c} = ['\zeta = ', num2str(round(zRange(c),2))];
end
ylabel('Transmissability $\left|{\ddot{y}}/{\ddot{w}_b}\right|$ [dB]','Interpreter','latex')
xlabel('Frequency [Hz]','Interpreter','latex')
xlim([48 100])
ylim([-40 40])
lgd = legend(['T',leg])
%% Compare with Sugino model
% Prepare the model of Sugino
b = 40e-3;%40e-3;
h = 2e-3; %2e-3
hp = 0.5e-3; %0.5e-3
rho = 7800; %km/m^3 AL 2810
rhop = 7800;
% m = b*h*rho+b*2*hp*rhop; % find values that make more sense
m = b*h*rho; % find values that make more sense

E = 69e9;%215 steele,69 for Al
Ep = 6.2112e+10;%200e9;1/15.1e-12
% EI = b*h^3/12*E;%62 for A
EI = 2*b/3*(E*h^3/8+Ep*((hp+h/2)^3-h^3/8));
L = 0.41;%0.44

nmax = 30;
% Clamped - free
lbd = [1.87510407; 4.69409113; 7.85475744; 10.99554073; 14.137168391046470580917046812552];

% theoretical
S = 2;
Hs = beamSSfun(S);
for n = 1:S
Hs0(n,n) = real(freqresp(Hs(sen(n+1),act(n+1)),0*pi*2));
end

if nmax>=6
    for n = 6:nmax
    lbd(n) = (2*n-1)*pi/2;
    end
end

for n = 1:nmax
        sig(n) = -(sin(lbd(n))-sinh(lbd(n)))/(cos(lbd(n))+cosh(lbd(n)));
        wr(n) = lbd(n)^2*sqrt(EI/m/L^4);
end
Phi = @(lb,sg,xL) (cosh(lb*xL)-cos(lb*xL)-sg*(sinh(lb*xL)-sin(lb*xL))); 
PhiH = @(lb,sg,xL) cos(lb*xL)-sin(lb*xL)-exp(-lb*xL)-exp(lb*(xL-1))*sin(lb); % approximation for n>10, Sugino2017
syms xLs
for n = 1:nmax
    if n<10
    Phis(n) = vpa(subs(Phi(lbd(n), sig(n),xLs)));
%         Mb(n) =  vpa(Phi(lbd(n), sig(n),1)*int(Phis(n),[0 1])/int(Phis(n)*Phis(n),[0 1]));
%         Mb(n) =  vpa(subs(Phi(lbd(n), sig(n),1)*int(Phis(n),[0 1]))); % I change the variable of integration, this should be compensated
        Mb(n) = vpa(Phi(lbd(n), sig(n),1)*Phi(lbd(n), sig(n),2/13)); % for compliance
    else 
    Phis(n) = vpa(subs(PhiH(lbd(n), sig(n),xLs)));  
%         Mb(n) =  vpa(PhiH(lbd(n), sig(n),1)*int(Phis(n),[0 1])/int(Phis(n)*Phis(n),[0 1]));
%         Mb(n) =  vpa(subs(PhiH(lbd(n), sig(n),1)*int(Phis(n),[0 1]))); % for transmissibility
        Mb(n) = vpa(PhiH(lbd(n), sig(n),1)*PhiH(lbd(n), sig(n),1/13)); % for compliance
    end
end
Mb = double(Mb);
%% Compare with Sugino model - Plot the results 
clr = parula(5);
% close all
fig=figure('units','centimeters');
fig.Position = [1 1 19 15];
semilogx([1 1e3],[-100 -100],'--','linewidth',1,'Color','k','HandleVisibility','off')
hold on

%tansducer locations
Dx = L/13;%60e-3; % Length of the transducer
xL = (0:12)*Dx;%[10e-3, 97e-3, 166e-3, 293e-3]; % Beginning of the transducer

freq = 2*pi*logspace(0,3,1e3);

w = freq;
wp = 2*pi*50;
Kp = 0.5; % max gain 2.3
Kcor = 1; % correction fractor
zp = 0.0;
% Model of Sugino
TOLresp = 0;
TCLresp = 0;
TKresp = 0;
TCLSresp = 0;
 Ch = -Kp/Kcor./(-w.^2/wp^2 + 2*0*w/wp + 1); 

for n = 1:nmax
    % for transmisssibility
%     TOLresp = TOLresp+Mb(n)*wr(n)^2./(-w.^2+wr(n)^2);
%  TCLresp = TCLresp + Mb(n)*(1+w.^2./(-w.^2+wr(n)^2*(1+Ch)));
% TCLresp = TCLresp+Mb(n)*wr(n)^2.*(-w.^2./wp^2 +1)./((-w.^2+wr(n)^2).*(-w.^2./wp^2  +1)-Kp/Kcor*w.^2);
    % for compliance
%     TCLresp = TCLresp+1/(m*L)*Mb(n)*(-w.^2/wp^2+1)./((-w.^2+wr(n)^2).*(-w.^2./wp^2  +1)-Kp/Kcor*wr(n)^2);
    TOLresp = TOLresp+1/(m*L)*Mb(n)*1./(-w.^2+wr(n)^2);
    TCLresp = TCLresp+1/(m*L)*Mb(n)*1./(-w.^2+wr(n)^2*(1+Ch));
end

% Theoretical ss beam
wc = wp;
Kc = Kp;
clear PPFs
for n = 1:S
PPFs(n,n) = inv(Hs0(n,n))*Kc*tf([1],[1/wc^2 2*zp/wc 1]);
PPFs(n,n).InputName = sen(n+1);
PPFs(n,n).OutputName = act(n+1);
end
Ts = feedback(Hs,PPFs,1,'name');

% From SpaCar
wc = wp;
Kc = Kp;
clear PPF PPFd
for n = 1:size(H,1)-1
PPF(n,n) = inv(H0(n,n))*Kc*tf([1],[1/wc^2 2*zp/wc 1]);
PPFd(n,n) = c2d(PPF(n,n),1e-4,'tustin');
PPFd(n,n).InputName = sen(n+1);
PPFd(n,n).OutputName = act(n+1);
end
T = feedback(H,PPFd,1,'name');


semilogx(freq/2/pi, 20*log10(abs(TOLresp)),'linewidth',2)
hold on
% semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H(1,1),freq)))),'linewidth',2,'Color','k')

semilogx(freq/2/pi, 20*log10(abs(TCLresp)),'linewidth',2)
% semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(T(1,1),freq)))),'linewidth',2)
% semilogx(freq/2/pi, 20*log10(abs(TCLSresp)),'linewidth',2)


semilogx(wp/2/pi*[1 1],[-40 40]-100,'--','linewidth',1,'Color','k','HandleVisibility','off')
semilogx(wp/2/pi*sqrt(1-Kp/Kcor)*[1 1],[-40 40]-100,'--','linewidth',1,'Color','k','HandleVisibility','off')
% semilogx(abs(imag(eig(d2c(T))))/2/pi,ones(size(eig(T)))-100,'*','HandleVisibility','off')
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(Hs(1,1),freq)))),'linewidth',2)
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(Ts(1,1),freq)))),'linewidth',2)


% semilogx(abs(imag(eig(d2c(H))))/2/pi,ones(size(eig(H))),'r*','HandleVisibility','off')

ylabel('Transmissability $\left|{\ddot{y}}/{\ddot{w}_b}\right|$ [dB]','Interpreter','latex')
xlabel('Frequency [Hz]','Interpreter','latex')
legend('OL Model','OL FEM','CL Model','CL FEM','OL S Model','CL S Model')
% xlim([150 600])
% xlim([10 40])
% ylim([-50 50])
%% Relationship to the number of pairs
% clr = parula(10);
% close all
% fig=figure('units','centimeters');
% fig.Position = [1 1 19 15];
% freq = 2*pi*logspace(0,3,1e3);
% % Sugino-model
% 
% w = freq;
% wp = 2*pi*128;
% Kp = 1; % max gain 2.3
% Kcor = 2; % correction fractor
% zp = 0.0;
% % Model of Sugino
% TOLresp = 0;
% TCLresp = 0;
% TKresp = 0;
% C = -1./(-w.^2/wp^2+2*zp*1j.*w/wp+1);
% for n = 1:nmax
%  TOLresp = TOLresp+Mb(n)*wr(n)^2./(-w.^2+wr(n)^2);
%  TCLresp = TCLresp+Mb(n)*wr(n)^2./(-w.^2+wr(n)^2+Kp/Kcor*w.^2.*C);
% end
% semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k','HandleVisibility','off')
% hold on
% semilogx(freq/2/pi, 20*log10(abs(TCLresp)),'linewidth',2,'Color','k')
% semilogx(wp/2/pi*[1 1],[-40 40],'--','linewidth',1,'Color','k','HandleVisibility','off')
% semilogx(wp/2/pi*sqrt(1+Kp/Kcor)*[1 1],[-40 40],'--','linewidth',1,'Color','k','HandleVisibility','off')
% 
% % Spacar for differnt number of cells
% for S = 1:10
% load(['sysCtrlN',num2str(S),'.mat'])
% % calculate static gain
% H = c2d(sysCtrl,1e-4);
% act = H.InputName;
% sen = H.OutputName;
% for n = 1:size(H,1)-1
% H0(n,n) = real(freqresp(H(sen(n+1),act(n+1)),0*pi*2));
% end
% % controller and closed loop
% clear PPF PPFd
% for n = 1:size(H,1)-1
% PPF(n,n) = inv(H0(n,n))*Kp*tf([1],[1/wp^2 2*zp/wp 1+Kp]);
% PPFd(n,n) = c2d(PPF(n,n),1e-4,'tustin');
% PPFd(n,n).InputName = sen(n+1);
% PPFd(n,n).OutputName = act(n+1);
% end
% T = feedback(H,PPFd,1,'name');
% 
% % semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(sysCtrl(1,1),freq)))),'linewidth',2,'Color',clr(S,:))
% semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(T(1,1),freq)))),'linewidth',2,'Color',clr(S,:))
% leg{S} = ['N = ', num2str(round(S,0))];
% hold on
% end
% lgd = legend(['N = \infty',leg])
% % xlim([3 5])
% % xlim([12 24])
% % xlim([60 80])

