%% FigBandgapZeta
% Figure size: 1 column 90mm, 1.5 column 140mm, 2 column 190mm
% https://www.elsevier.com/about/policies-and-standards/author/artwork-and-media-instructions/artwork-sizing
load('FigBgZeta.mat')
clr = jet(9);
close all
fig=figure('units','centimeters');
fig.Position = [1 1 19 7];
% tlo =tiledlayout(4,1,'TileSpacing','tight','Padding','tight','units','centimeters')
% tlo.OuterPosition = [0 0 19 19]
% ax1 = nexttile([2,1])


% semilogx(HCL20.Frequency/2/pi, 20*log10(abs(squeeze(HCL20.ResponseData))),'linewidth',2,'Color',clr(1,:))
semilogx(HOL(1,1).Frequency/2/pi, 20*log10(abs(squeeze(HOL(1,1).ResponseData))),'linewidth',2,'Color','k')
hold on
semilogx(HCL20z03.Frequency/2/pi, 20*log10(abs(squeeze(HCL20z03.ResponseData))),'linewidth',2,'Color',clr(1,:))
semilogx(HCL20z04.Frequency/2/pi, 20*log10(abs(squeeze(HCL20z04.ResponseData))),'linewidth',2,'Color',clr(2,:))
semilogx(HCL20z05.Frequency/2/pi, 20*log10(abs(squeeze(HCL20z05.ResponseData))),'linewidth',2,'Color',clr(3,:))
semilogx(HCL20z06.Frequency/2/pi, 20*log10(abs(squeeze(HCL20z06.ResponseData))),'linewidth',2,'Color',clr(4,:))
semilogx(HCL20z07.Frequency/2/pi, 20*log10(abs(squeeze(HCL20z07.ResponseData))),'linewidth',2,'Color',clr(5,:))
semilogx(HCL20z08.Frequency/2/pi, 20*log10(abs(squeeze(HCL20z08.ResponseData))),'linewidth',2,'Color',clr(6,:))
semilogx(HCL20z09.Frequency/2/pi, 20*log10(abs(squeeze(HCL20z09.ResponseData))),'linewidth',2,'Color',clr(8,:))
semilogx(HCL20z10.Frequency/2/pi, 20*log10(abs(squeeze(HCL20z10.ResponseData))),'linewidth',2,'Color',clr(9,:))

semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k')

semilogx(20*[1 1],[-30 30],'--','linewidth',1,'Color','k')

ylabel('Transmissability $\left|{\ddot{y}}/{\ddot{w}_b}\right|$ [dB]','Interpreter','latex')
ylim([-25 25])
legend('uncontrolled','\zeta=0.03','\zeta=0.04','\zeta=0.05','\zeta=0.06','\zeta=0.07','\zeta=0.08','\zeta=0.09','\zeta=0.10')
% ax2 = nexttile
% semilogx(HL(2,2).Frequency/2/pi, 20*log10(abs(squeeze(HL(2,2).ResponseData))),'linewidth',2)
% hold on
% semilogx(HL(3,3).Frequency/2/pi, 20*log10(abs(squeeze(HL(3,3).ResponseData))),'linewidth',2)
% semilogx(HL(4,4).Frequency/2/pi, 20*log10(abs(squeeze(HL(4,4).ResponseData))),'linewidth',2)
% semilogx(HL(5,5).Frequency/2/pi, 20*log10(abs(squeeze(HL(5,5).ResponseData))),'linewidth',2)
% 
% semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k')
% ylabel('$\left|{q_{1,j}}/{v_{2,j}}\right|$ [dB]','Interpreter','latex')


% ax3 = nexttile
% semilogx(HL(3,3).Frequency/2/pi, rad2deg(phase(squeeze(HL(2,2).ResponseData))),'linewidth',2)
% hold on
% semilogx(HL(3,3).Frequency/2/pi, rad2deg(phase(squeeze(HL(3,3).ResponseData))),'linewidth',2)
% semilogx(HL(4,4).Frequency/2/pi, rad2deg(phase(squeeze(HL(4,4).ResponseData))),'linewidth',2)
% semilogx(HL(5,5).Frequency/2/pi, rad2deg(phase(squeeze(-1*HL(5,5).ResponseData))),'linewidth',2)
% 
% semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k')
% ylim([-30 30])
% ylabel('$\angle\left({q_{1,j}}/{v_{2,j}}\right)$ [deg]','Interpreter','latex')
% 
% linkaxes([ax1 ax2 ax3],'x')
xlim([15 30])
xlabel('Frequency [Hz]','Interpreter','latex')


