%% FigBandgap20z07
% Figure size: 1 column 90mm, 1.5 column 140mm, 2 column 190mm
% https://www.elsevier.com/about/policies-and-standards/author/artwork-and-media-instructions/artwork-sizing
clr = jet(7);
close all
fig=figure('units','centimeters');
fig.Position = [1 1 19 15];
% tlo =tiledlayout(4,1,'TileSpacing','tight','Padding','tight','units','centimeters')
% tlo.OuterPosition = [0 0 19 19]
% ax1 = nexttile([2,1])


% semilogx(HCL20.Frequency/2/pi, 20*log10(abs(squeeze(HCL20.ResponseData))),'linewidth',2,'Color',clr(1,:))
semilogx(HOL(1,1).Frequency/2/pi, 20*log10(abs(squeeze(HOL(1,1).ResponseData))),'linewidth',2,'Color','k')
hold on
semilogx(HCL20k05z07.Frequency/2/pi, 20*log10(abs(squeeze(HCL20k05z07.ResponseData))),'linewidth',2,'Color',clr(1,:))
semilogx(HCL20k10z07.Frequency/2/pi, 20*log10(abs(squeeze(HCL20k10z07.ResponseData))),'linewidth',2,'Color',clr(2,:))
semilogx(HCL20k15z07.Frequency/2/pi, 20*log10(abs(squeeze(HCL20k15z07.ResponseData))),'linewidth',2,'Color',clr(3,:))
semilogx(HCL20k2z07.Frequency/2/pi, 20*log10(abs(squeeze(HCL20k2z07.ResponseData))),'linewidth',2,'Color',clr(4,:))
semilogx(HCL20k25z07.Frequency/2/pi, 20*log10(abs(squeeze(HCL20k25z07.ResponseData))),'linewidth',2,'Color',clr(5,:))
semilogx(HCL20k30z07.Frequency/2/pi, 20*log10(abs(squeeze(HCL20k30z07.ResponseData))),'linewidth',2,'Color',clr(6,:))


semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k')

semilogx(20*[1 1],[-30 30],'--','linewidth',1,'Color','k')

ylabel('Transmissability $\left|{\ddot{y}}/{\ddot{w}_b}\right|$ [dB]','Interpreter','latex')
ylim([-25 25])
legend('OL','K=0.5','K=1.0','K=1.5','K=2.0','K=2.5','K=3.0')
% ax2 = nexttile
% semilogx(HL(2,2).Frequency/2/pi, 20*log10(abs(squeeze(HL(2,2).ResponseData))),'linewidth',2)
% hold on
% semilogx(HL(3,3).Frequency/2/pi, 20*log10(abs(squeeze(HL(3,3).ResponseData))),'linewidth',2)
% semilogx(HL(4,4).Frequency/2/pi, 20*log10(abs(squeeze(HL(4,4).ResponseData))),'linewidth',2)
% semilogx(HL(5,5).Frequency/2/pi, 20*log10(abs(squeeze(HL(5,5).ResponseData))),'linewidth',2)
% 
% semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k')
% ylabel('$\left|{q_{1,j}}/{v_{2,j}}\right|$ [dB]','Interpreter','latex')


% ax3 = nexttile
% semilogx(HL(3,3).Frequency/2/pi, rad2deg(phase(squeeze(HL(2,2).ResponseData))),'linewidth',2)
% hold on
% semilogx(HL(3,3).Frequency/2/pi, rad2deg(phase(squeeze(HL(3,3).ResponseData))),'linewidth',2)
% semilogx(HL(4,4).Frequency/2/pi, rad2deg(phase(squeeze(HL(4,4).ResponseData))),'linewidth',2)
% semilogx(HL(5,5).Frequency/2/pi, rad2deg(phase(squeeze(-1*HL(5,5).ResponseData))),'linewidth',2)
% 
% semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k')
% ylim([-30 30])
% ylabel('$\angle\left({q_{1,j}}/{v_{2,j}}\right)$ [deg]','Interpreter','latex')
% 
% linkaxes([ax1 ax2 ax3],'x')
xlim([15 30])
xlabel('Frequency [Hz]','Interpreter','latex')

