%% FigBandgap
% Figure size: 1 column 90mm, 1.5 column 140mm, 2 column 190mm
% https://www.elsevier.com/about/policies-and-standards/author/artwork-and-media-instructions/artwork-sizing
load('FigBandgapFRD2.mat')
clr = jet(7);
close all
fig=figure('units','centimeters');
fig.Position = [1 1 19 7.5];
% tlo =tiledlayout(4,1,'TileSpacing','tight','Padding','tight','units','centimeters')
% tlo.OuterPosition = [0 0 19 19]
% ax1 = nexttile([2,1])
semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k','HandleVisibility','off')
hold on
semilogx(320*[1 1],[-30 30],'--','linewidth',1,'Color',clr(7,:),'HandleVisibility','off')
semilogx(160*[1 1],[-30 30],'--','linewidth',1,'Color',clr(6,:),'HandleVisibility','off')
semilogx(80*[1 1],[-30 30],'--','linewidth',1,'Color',clr(4,:),'HandleVisibility','off')
semilogx(40*[1 1],[-30 30],'--','linewidth',1,'Color',clr(3,:),'HandleVisibility','off')
semilogx(20*[1 1],[-30 30],'--','linewidth',1,'Color',clr(2,:),'HandleVisibility','off')
semilogx(10*[1 1],[-30 30],'--','linewidth',1,'Color',clr(1,:),'HandleVisibility','off')
semilogx(320*sqrt(1+0.5)*[1 1],[-30 30],'--','linewidth',1,'Color',clr(7,:),'HandleVisibility','off')
semilogx(160*sqrt(1+0.5)*[1 1],[-30 30],'--','linewidth',1,'Color',clr(6,:),'HandleVisibility','off')
semilogx(80*sqrt(1+0.5)*[1 1],[-30 30],'--','linewidth',1,'Color',clr(4,:),'HandleVisibility','off')
semilogx(40*sqrt(1+0.5)*[1 1],[-30 30],'--','linewidth',1,'Color',clr(3,:),'HandleVisibility','off')
semilogx(20*sqrt(1+0.5)*[1 1],[-30 30],'--','linewidth',1,'Color',clr(2,:),'HandleVisibility','off')
semilogx(10*sqrt(1+0.5)*[1 1],[-30 30],'--','linewidth',1,'Color',clr(1,:),'HandleVisibility','off')



% semilogx(85*[1 1],[-30 30],'--','linewidth',1,'Color',clr(7,:))
% semilogx(150*[1 1],[-30 30],'--','linewidth',1,'Color',clr(8,:))
% semilogx(200*[1 1],[-30 30],'--','linewidth',1,'Color',clr(9,:))
% semilogx(250*[1 1],[-30 30],'--','linewidth',1,'Color',clr(10,:))
% semilogx(300*[1 1],[-30 30],'--','linewidth',1,'Color',clr(11,:))


% semilogx(20*[1 1],[-30 30],'--','linewidth',1,'Color',clr(1,:))
% semilogx(30*[1 1],[-30 30],'--','linewidth',1,'Color',clr(2,:))
% semilogx(40*[1 1],[-30 30],'--','linewidth',1,'Color',clr(3,:))
% semilogx(60*[1 1],[-30 30],'--','linewidth',1,'Color',clr(4,:))
% semilogx(80*[1 1],[-30 30],'--','linewidth',1,'Color',clr(5,:))
% semilogx(120*[1 1],[-30 30],'--','linewidth',1,'Color',clr(6,:))
% semilogx(160*[1 1],[-30 30],'--','linewidth',1,'Color',clr(7,:))
% semilogx(220*[1 1],[-30 30],'--','linewidth',1,'Color',clr(8,:))
% semilogx(320*[1 1],[-30 30],'--','linewidth',1,'Color',clr(9,:))
% semilogx(250*[1 1],[-30 30],'--','linewidth',1,'Color',clr(10,:))
% semilogx(300*[1 1],[-30 30],'--','linewidth',1,'Color',clr(11,:))
% semilogx(HCL322.Frequency/2/pi, 20*log10(abs(squeeze(HCL322.ResponseData))),'linewidth',2,'Color',clr(7,:))
semilogx(HCL320.Frequency/2/pi, 20*log10(abs(squeeze(HCL320.ResponseData))),'linewidth',2,'Color',clr(7,:))
semilogx(HCL160.Frequency/2/pi, 20*log10(abs(squeeze(HCL160.ResponseData))),'linewidth',2,'Color',clr(6,:))
semilogx(HCL80.Frequency/2/pi, 20*log10(abs(squeeze(HCL80.ResponseData))),'linewidth',2,'Color',clr(4,:))
semilogx(HCL40.Frequency/2/pi, 20*log10(abs(squeeze(HCL40.ResponseData))),'linewidth',2,'Color',clr(3,:))
semilogx(HCL20.Frequency/2/pi, 20*log10(abs(squeeze(HCL20.ResponseData))),'linewidth',2,'Color',clr(2,:))
semilogx(HCL10.Frequency/2/pi, 20*log10(abs(squeeze(HCL10.ResponseData))),'linewidth',2,'Color',clr(1,:))

semilogx(HL(1,1).Frequency/2/pi, 20*log10(abs(squeeze(HL(1,1).ResponseData))),'linewidth',2,'Color','k')

legh = legend('$\omega_c = 320$ Hz','$\omega_c = 160$ Hz','$\omega_c = 80$ Hz','$\omega_c = 40$ Hz','$\omega_c = 20$ Hz','$\omega_c = 10$ Hz','uncontrolled','interpreter','latex')
% semilogx(TOL.Frequency/2/pi, 20*log10(abs(squeeze(TOL.ResponseData))),'--','linewidth',2,'Color',clr(1,:))
legh.ItemTokenSize(1) = 15;
set(legh,'Position',[0.5 0.96 0.0 0.0],'Orientation','horizontal')
% semilogx(320*sqrt(1+0.2)*[1 1],[-30 30],'--','linewidth',1,'Color',clr(7,:))
% semilogx(160*sqrt(1+0.2)*[1 1],[-30 30],'--','linewidth',1,'Color',clr(6,:))
% semilogx(80*sqrt(1+0.2)*[1 1],[-30 30],'--','linewidth',1,'Color',clr(4,:))
% semilogx(40*sqrt(1+0.2)*[1 1],[-30 30],'--','linewidth',1,'Color',clr(3,:))
% semilogx(20*sqrt(1+0.2)*[1 1],[-30 30],'--','linewidth',1,'Color',clr(2,:))
% semilogx(10*sqrt(1+0.2)*[1 1],[-30 30],'--','linewidth',1,'Color',clr(1,:))

% semilogx(HCL25.Frequency(5:end-20)/2/pi, 20*log10(abs(squeeze(HCL25.ResponseData(5:end-20)))),'linewidth',2,'Color',clr(1,:))
% semilogx(HCL35.Frequency(30:end)/2/pi, 20*log10(abs(squeeze(HCL35.ResponseData(30:end)))),'linewidth',2,'Color',clr(2,:))
% semilogx(HCL45.Frequency(1:end-70)/2/pi, 20*log10(abs(squeeze(HCL45.ResponseData(1:end-70)))),'linewidth',2,'Color',clr(3,:))
% semilogx(HCL55.Frequency(5:end-50)/2/pi, 20*log10(abs(squeeze(HCL55.ResponseData(5:end-50)))),'linewidth',2,'Color',clr(4,:))
% semilogx(HCL65.Frequency(35:end-40)/2/pi, 20*log10(abs(squeeze(HCL65.ResponseData(35:end-40)))),'linewidth',2,'Color',clr(5,:))
% semilogx(HCL75.Frequency(45:end-10)/2/pi, 20*log10(abs(squeeze(HCL75.ResponseData(45:end-10)))),'linewidth',2,'Color',clr(6,:))
% semilogx(HCL85.Frequency(55:end)/2/pi, 20*log10(abs(squeeze(HCL85.ResponseData(55:end)))),'linewidth',2,'Color',clr(7,:))
% semilogx(HCL150.Frequency(20:end-60)/2/pi, 20*log10(abs(squeeze(HCL150.ResponseData(20:end-60)))),'linewidth',2,'Color',clr(8,:))
% semilogx(HCL200.Frequency(15:end-40)/2/pi, 20*log10(abs(squeeze(HCL200.ResponseData(15:end-40)))),'linewidth',2,'Color',clr(9,:))
% semilogx(HCL250.Frequency(15:end)/2/pi, 20*log10(abs(squeeze(HCL250.ResponseData(15:end)))),'linewidth',2,'Color',clr(10,:))
% semilogx(HCL300.Frequency(15:end-10)/2/pi, 20*log10(abs(squeeze(HCL300.ResponseData(15:end-10)))),'linewidth',2,'Color',clr(11,:))
% ylim([-25 25])

ylabel('Transmissability $\left|{\ddot{y}}/{\ddot{w}_b}\right|$ [dB]','Interpreter','latex')
ylim([-20 25])
% ax2 = nexttile
% semilogx(HL(2,2).Frequency/2/pi, 20*log10(abs(squeeze(HL(2,2).ResponseData))),'linewidth',2)
% hold on
% semilogx(HL(3,3).Frequency/2/pi, 20*log10(abs(squeeze(HL(3,3).ResponseData))),'linewidth',2)
% semilogx(HL(4,4).Frequency/2/pi, 20*log10(abs(squeeze(HL(4,4).ResponseData))),'linewidth',2)
% semilogx(HL(5,5).Frequency/2/pi, 20*log10(abs(squeeze(HL(5,5).ResponseData))),'linewidth',2)
% 
% semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k')
% ylabel('$\left|{q_{1,j}}/{v_{2,j}}\right|$ [dB]','Interpreter','latex')


% ax3 = nexttile
% semilogx(HL(3,3).Frequency/2/pi, rad2deg(phase(squeeze(HL(2,2).ResponseData))),'linewidth',2)
% hold on
% semilogx(HL(3,3).Frequency/2/pi, rad2deg(phase(squeeze(HL(3,3).ResponseData))),'linewidth',2)
% semilogx(HL(4,4).Frequency/2/pi, rad2deg(phase(squeeze(HL(4,4).ResponseData))),'linewidth',2)
% semilogx(HL(5,5).Frequency/2/pi, rad2deg(phase(squeeze(-1*HL(5,5).ResponseData))),'linewidth',2)
% 
% semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k')
% ylim([-30 30])
% ylabel('$\angle\left({q_{1,j}}/{v_{2,j}}\right)$ [deg]','Interpreter','latex')
% 
% linkaxes([ax1 ax2 ax3],'x')
xlim([5 1000])
xlabel('Frequency [Hz]','Interpreter','latex')
%% Plot collocated TFs

fig=figure('units','centimeters');
fig.Position = [1 1 9 7];
tlo =tiledlayout(2,1,'TileSpacing','tight','Padding','tight','units','centimeters')
% % tlo.OuterPosition = [0 0 19 19]
ax1 = nexttile
semilogx(HL(2,2).Frequency/2/pi, 20*log10(abs(squeeze(HL(2,2).ResponseData))),'linewidth',2)
hold on
semilogx(HL(3,3).Frequency/2/pi, 20*log10(abs(squeeze(HL(3,3).ResponseData))),'linewidth',2)
semilogx(HL(4,4).Frequency/2/pi, 20*log10(abs(squeeze(HL(4,4).ResponseData))),'linewidth',2)
semilogx(HL(5,5).Frequency/2/pi, 20*log10(abs(squeeze(HL(5,5).ResponseData))),'linewidth',2)

semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k')
ylabel('$\left|{q_{1,j}}/{v_{2,j}}\right|$ [dB]','Interpreter','latex')
legend('j = 1','j = 2','j = 3','j = 4')
ylim([-20 20])

ax3 = nexttile
semilogx(HL(3,3).Frequency/2/pi, rad2deg(phase(squeeze(HL(2,2).ResponseData))),'linewidth',2)
hold on
semilogx(HL(3,3).Frequency/2/pi, rad2deg(phase(squeeze(HL(3,3).ResponseData))),'linewidth',2)
semilogx(HL(4,4).Frequency/2/pi, rad2deg(phase(squeeze(HL(4,4).ResponseData))),'linewidth',2)
semilogx(HL(5,5).Frequency/2/pi, rad2deg(phase(squeeze(-1*HL(5,5).ResponseData))),'linewidth',2)

semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k')
ylim([-180 30])
ylabel('$\angle\left({q_{1,j}}/{v_{2,j}}\right)$ [deg]','Interpreter','latex')
yticks(45*(-10:1:10))
% 
% linkaxes([ax1 ax2 ax3],'x')
xlim([1 1000])
xlabel('Frequency [Hz]','Interpreter','latex')

%% Plot Collocated model
% load('H2.mat')
freq = logspace(0,3,1e3)*2*pi;
fig=figure('units','centimeters');
fig.Position = [1 1 9 7];
tlo =tiledlayout(2,1,'TileSpacing','tight','Padding','tight','units','centimeters')
% % tlo.OuterPosition = [0 0 19 19]
ax1 = nexttile
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H2(2,2),freq)))),'linewidth',2)
hold on
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H2(3,3),freq)))),'linewidth',2)
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H2(4,4),freq)))),'linewidth',2)
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H2(5,5),freq)))),'linewidth',2)

semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k')
ylabel('$\left|{q_{1,j}}/{v_{2,j}}\right|$ [dB]','Interpreter','latex')
% legend('Pair 1','Pair 2','Pair 3','Pair 4')
legend('j = 1','j = 2','j = 3','j = 4')


ax3 = nexttile
semilogx(freq/2/pi, rad2deg(phase(squeeze(freqresp(H2(2,2),freq)))),'linewidth',2)
hold on
semilogx(freq/2/pi, rad2deg(phase(squeeze(freqresp(H2(3,3),freq)))),'linewidth',2)
semilogx(freq/2/pi, rad2deg(phase(squeeze(freqresp(H2(4,4),freq)))),'linewidth',2)
semilogx(freq/2/pi, rad2deg(phase(squeeze(freqresp(H2(5,5),freq)))),'linewidth',2)


semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k')
ylim([-180 30])
ylabel('$\angle\left({q_{1,j}}/{v_{2,j}}\right)$ [deg]','Interpreter','latex')
yticks(45*(-10:1:10))
% 
% linkaxes([ax1 ax2 ax3],'x')
xlim([1 1000])
xlabel('Frequency [Hz]','Interpreter','latex')
%% Plot OL

clr = lines;
close all
% fig=figure('units','centimeters');
% fig.Position = [1 1 19 7];
tlo =tiledlayout(3,3,'TileSpacing','tight','Padding','tight','units','centimeters')
ax11 = nexttile % 1,1
semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k','HandleVisibility','off')
hold on
semilogx(HL(1,1).Frequency/2/pi, 20*log10(abs(squeeze(HL(1,1).ResponseData))),'linewidth',2,'Color',clr(1,:))
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H2(1,1),freq)))),'linewidth',2,'Color',clr(2,:))
title('from $\ddot{w}$','Interpreter','latex')
ylabel(ax11,'to $\ddot{y}$','Interpreter','latex')
ax12 = nexttile %1,2
semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k','HandleVisibility','off')
hold on
semilogx(HL(1,2).Frequency/2/pi, 20*log10(abs(squeeze(HL(1,2).ResponseData))),'linewidth',2,'Color',clr(1,:))
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H2(1,2),freq)))),'linewidth',2,'Color',clr(2,:))
title('from $v_{2,1}$','Interpreter','latex')


ax13 = nexttile %1,3
semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k','HandleVisibility','off')
hold on
semilogx(HL(1,3).Frequency/2/pi, 20*log10(abs(squeeze(HL(1,3).ResponseData))),'linewidth',2,'Color',clr(1,:))
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H2(1,3),freq)))),'linewidth',2,'Color',clr(2,:))
title('from $v_{2,2}$','Interpreter','latex')


ax21 = nexttile %2,1
semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k','HandleVisibility','off')
hold on
semilogx(HL(2,1).Frequency/2/pi, 20*log10(abs(squeeze(HL(2,1).ResponseData))),'linewidth',2,'Color',clr(1,:))
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H2(2,1),freq)))),'linewidth',2,'Color',clr(2,:))
ylabel(ax21,'to $q_{1,1}$','Interpreter','latex')
ax22 = nexttile % 2,2
semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k','HandleVisibility','off')
hold on
semilogx(HL(2,2).Frequency/2/pi, 20*log10(abs(squeeze(HL(2,2).ResponseData))),'linewidth',2,'Color',clr(1,:))
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H2(2,2),freq)))),'linewidth',2,'Color',clr(2,:))

ax23 = nexttile %2,3
semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k','HandleVisibility','off')
hold on
semilogx(HL(2,3).Frequency/2/pi, 20*log10(abs(squeeze(HL(2,3).ResponseData))),'linewidth',2,'Color',clr(1,:))
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H2(2,3),freq)))),'linewidth',2,'Color',clr(2,:))

ax31 = nexttile %3,1
semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k','HandleVisibility','off')
hold on
semilogx(HL(3,1).Frequency/2/pi, 20*log10(abs(squeeze(HL(3,1).ResponseData))),'linewidth',2,'Color',clr(1,:))
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H2(3,1),freq)))),'linewidth',2,'Color',clr(2,:))
ylabel(ax31,'to $q_{1,2}$','Interpreter','latex')

ax32 = nexttile % 3,2
semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k','HandleVisibility','off')
hold on
semilogx(HL(3,2).Frequency/2/pi, 20*log10(abs(squeeze(HL(3,2).ResponseData))),'linewidth',2,'Color',clr(1,:))
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H2(3,2),freq)))),'linewidth',2,'Color',clr(2,:))

ax33 = nexttile %3,3
semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k','HandleVisibility','off')
hold on
semilogx(HL(3,3).Frequency/2/pi, 20*log10(abs(squeeze(HL(3,3).ResponseData))),'linewidth',2,'Color',clr(1,:))
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H2(3,3),freq)))),'linewidth',2,'Color',clr(2,:))

xlabel(tlo,'Frequency [Hz]','Interpreter','latex')
ylabel(tlo,'Magnitude [dB]','Interpreter','latex')

linkaxes([ax11 ax21 ax31],'x')
linkaxes([ax12 ax22 ax32],'x')
linkaxes([ax13 ax23 ax33],'x')

linkaxes([ax11 ax12 ax13],'y')
linkaxes([ax21 ax22 ax23],'y')
linkaxes([ax31 ax32 ax33],'y')

%% Recreate with SpaCar model
% clear all
% load('sysAcc.mat')
% H = c2d(sysAcc,1e-4);
% load('H2.mat')
H = H2;
% H = sysAcc;
% H.OutputDelay = 0*[0 1 1 1 1];
act = H.InputName;
sen = H.OutputName;
for n = 1:size(H,1)-1
H0(n,n) = real(freqresp(H(sen(n+1),act(n+1)),0*pi*2));
end
wrange = ([10 20 40 80 160 320])*2*pi;
freq = 2*pi*logspace(0,3,1e3);

clr = jet(7);
close all
fig=figure('units','centimeters');
fig.Position = [1 1 19 7.5];
semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k','HandleVisibility','off')

hold on
semilogx(320*[1 1],[-30 30],'--','linewidth',1,'Color',clr(7,:),'HandleVisibility','off')
semilogx(160*[1 1],[-30 30],'--','linewidth',1,'Color',clr(6,:),'HandleVisibility','off')
semilogx(80*[1 1],[-30 30],'--','linewidth',1,'Color',clr(4,:),'HandleVisibility','off')
semilogx(40*[1 1],[-30 30],'--','linewidth',1,'Color',clr(3,:),'HandleVisibility','off')
semilogx(20*[1 1],[-30 30],'--','linewidth',1,'Color',clr(2,:),'HandleVisibility','off')
semilogx(10*[1 1],[-30 30],'--','linewidth',1,'Color',clr(1,:),'HandleVisibility','off')
semilogx(320*sqrt(1+0.5)*[1 1],[-30 30],'--','linewidth',1,'Color',clr(7,:),'HandleVisibility','off')
semilogx(160*sqrt(1+0.5)*[1 1],[-30 30],'--','linewidth',1,'Color',clr(6,:),'HandleVisibility','off')
semilogx(80*sqrt(1+0.5)*[1 1],[-30 30],'--','linewidth',1,'Color',clr(4,:),'HandleVisibility','off')
semilogx(40*sqrt(1+0.5)*[1 1],[-30 30],'--','linewidth',1,'Color',clr(3,:),'HandleVisibility','off')
semilogx(20*sqrt(1+0.5)*[1 1],[-30 30],'--','linewidth',1,'Color',clr(2,:),'HandleVisibility','off')
semilogx(10*sqrt(1+0.5)*[1 1],[-30 30],'--','linewidth',1,'Color',clr(1,:),'HandleVisibility','off')
clear PPF PPFd
for m = flip(1:length(wrange))
for n = 1:size(H,1)-1
    wp = wrange(m);
    Kp = 0.5; % max gain 2.3
    zp = 0.05;



PPF(n,n) = inv(H0(n,n))*Kp*tf([1],[1/wp^2 2*zp/wp 1+Kp]);

PPF(n,n).InputName = sen(n+1);
PPF(n,n).OutputName = act(n+1);

T = feedback(H,PPF,1,'name');

if n == 1  
PPFhp(n,n) = inv(H0(n,n))*Kp*tf([1],[1/wp^2 2*zp/wp 1+Kp])*tf([1 0],[1 2*pi*1]);
else 
PPFhp(n,n) = inv(H0(n,n))*Kp*tf([1],[1/wp^2 2*zp/wp 1+Kp])*tf([1 0],[1 2*pi*1]);
end
% PPFd(n,n) = c2d(PPF(n,n),1e-4,'tustin');
% PPF(n,n).InputDelay =1e-4;
PPFhp(n,n).InputName = sen(n+1);
PPFhp(n,n).OutputName = act(n+1);
end
Thp = feedback(H,PPFhp,1,'name');
% isstable(T)
if m<=4
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(T(1,1),freq)))),'linewidth',2,'Color',clr(m,:))
% semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(Thp(1,1),freq)))),'-.','linewidth',2,'Color',clr(m,:))

else
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(T(1,1),freq)))),'linewidth',2,'Color',clr(m+1,:))
% semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(Thp(1,1),freq)))),'-.','linewidth',2,'Color',clr(m+1,:))

end
end
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H(1,1),freq)))),'linewidth',2,'Color','k')
% legend('$\omega_t = 320$ Hz','$\omega_t = 160$ Hz','$\omega_t = 80$ Hz','$\omega_t = 40$ Hz','$\omega_t = 20$ Hz','$\omega_t = 10$ Hz','uncontrolled','interpreter','latex')
legh = legend('$\omega_c = 320$ Hz','$\omega_c = 160$ Hz','$\omega_c = 80$ Hz','$\omega_c = 40$ Hz','$\omega_c = 20$ Hz','$\omega_c = 10$ Hz','uncontrolled','interpreter','latex')
% semilogx(TOL.Frequency/2/pi, 20*log10(abs(squeeze(TOL.ResponseData))),'--','linewidth',2,'Color',clr(1,:))
legh.ItemTokenSize(1) = 15;
set(legh,'Position',[0.5 0.96 0.0 0.0],'Orientation','horizontal')
ylabel('Transmissability $\left|{\ddot{y}}/{\ddot{w}_b}\right|$ [dB]','Interpreter','latex')
ylim([-20 25])
xlim([5 1000])
xlabel('Frequency [Hz]','Interpreter','latex')
%% Different number of patches
% close all
%static compensation
% Hs = Hsold;
% Hs.D(2:end,2:end) = Hs.D(2:end,2:end)+diag(ones(S,1)*L/S/EI)-Hs0;
wc = wp;
Kc = Kp;
pairs  =[1 3 5];
clear PPF2

clr = lines(5);
fig=figure('units','centimeters');
fig.Position = [1 1 19 7];
semilogx([1 1e3],[-100 -100],'--','linewidth',1,'Color','k','HandleVisibility','off')
hold on

semilogx(wp/2/pi*[1 1],[-40 40],'--','linewidth',1,'Color','k','HandleVisibility','off')
semilogx(wp/2/pi*sqrt(1-Kp*Kcor)*[1 1],[-40 40],'--','linewidth',1,'Color','k','HandleVisibility','off')

semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(Hs(1,1),freq)))),'k-','linewidth',2)

for n = 1:length(pairs)
PPF2(n,n) = 1/Hs0(pairs(n),pairs(n))*Kc*tf([1],[1/wc^2 2*zp/wc 1]);
PPF2(n,n).InputName = sen(pairs(n)+1);
PPF2(n,n).OutputName = act(pairs(n)+1);

T2 = feedback(Hs,PPF2,1,'name');

semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(sminreal(T2(1,1)),freq)))),'linewidth',2,'Color',clr(n+1,:))
end
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(sminreal(Ts(1,1)),freq)))),'linewidth',2,'Color',clr(1,:))

% semilogx(abs(imag(eig((sminreal(T2(1,1))))))/2/pi,ones(size(eig(sminreal(T2(1,1))))),'r*','HandleVisibility','off')
xlabel('Frequency [Hz]','Interpreter','latex')
ylabel('Transmissability $\left|{\ddot{y}}/{\ddot{w}_b}\right|$ [dB]','Interpreter','latex')
xlim([10 30])
% xticks([10 20 30 100])
ylim([-40 40])
legend('uncontrolled','pair 1','pairs 1,3','pairs 1,3,5','all pairs','Location','best')


%% Try to match with SpaCar
load('sysCtrl.mat')
H = c2d(sysCtrl,1e-4);
% H.OutputDelay = 1*[0 1 1 1 1];
HPF = tf([1 0],[1 2*pi*0.5]); %charge amplifire dynamics
% HPF = tf([1],[1]); %charge amplifire dynamics
HPFd = c2d(HPF,1e-4); %charge amplifire dynamics
act = H.InputName;
sen = H.OutputName;
for n = 1:size(H,1)-1
H0(n,n) = real(freqresp(H(sen(n+1),act(n+1)),0*pi*2));
end
clear PPF PPFd
wp =20*2*pi;
Kp = 1; % max gain 2.3
zp = 0.05;
for n = 1:size(H,1)-1
PPF(n,n) = inv(H0(n,n))*Kp*tf([1],[1/wp^2 2*zp/wp 1+Kp]);%*tf([1 0],[1 2*pi*1]);
PPFd(n,n) = c2d(PPF(n,n),1e-4,'tustin');
% PPFd(n,n).InputDelay = 1;
PPFd(n,n).InputName = sen(n+1);
PPFd(n,n).OutputName = act(n+1);
end
T = feedback(H,PPFd,1,'name');


freq = 2*pi*logspace(0,3,1e3);

fig=figure('units','centimeters');
fig.Position = [1 1 19 15];
% semilogx(HL(1,1).Frequency/2/pi, 20*log10(abs(squeeze(HL(1,1).ResponseData))),'linewidth',2,'Color',clr(1,:))
hold on
% semilogx(HCL20.Frequency/2/pi, 20*log10(abs(squeeze(HCL20.ResponseData))),'linewidth',2,'Color',clr(2,:))


semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H(1,1),freq)))),'linewidth',2,'Color',clr(3,:))
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(T(1,1),freq)))),'linewidth',2,'Color',clr(4,:))
% semilogx(abs(imag(eig(d2c(T))))/2/pi,ones(size(eig(T))),'*','HandleVisibility','off')

%% Try to match Collocated chanels
% clr = parula(4);
% fig=figure('units','centimeters');
% % fig.Position = [1 1 19 15];
% tlo =tiledlayout(2,1,'TileSpacing','tight','Padding','tight','units','centimeters')
% % % tlo.OuterPosition = [0 0 19 19]
% ax1 = nexttile
% semilogx(HL(2,2).Frequency/2/pi, 20*log10(abs(squeeze(HL(2,2).ResponseData))),'linewidth',2,'Color',clr(1,:))
% hold on
% semilogx(HL(3,3).Frequency/2/pi, 20*log10(abs(squeeze(HL(3,3).ResponseData))),'linewidth',2,'Color',clr(2,:))
% semilogx(HL(4,4).Frequency/2/pi, 20*log10(abs(squeeze(HL(4,4).ResponseData))),'linewidth',2,'Color',clr(3,:))
% semilogx(HL(5,5).Frequency/2/pi, 20*log10(abs(squeeze(HL(5,5).ResponseData))),'linewidth',2,'Color',clr(4,:))
% semilogx(freq/2/pi, 20*log10(db2mag(171)*abs(squeeze(freqresp(HPFd*H(2,2),freq)))),'--','linewidth',2,'Color',clr(1,:))
% semilogx(freq/2/pi, 20*log10(db2mag(171)*abs(squeeze(freqresp(HPFd*H(3,3),freq)))),'--','linewidth',2,'Color',clr(2,:))
% semilogx(freq/2/pi, 20*log10(db2mag(171)*abs(squeeze(freqresp(HPFd*H(4,4),freq)))),'--','linewidth',2,'Color',clr(3,:))
% semilogx(freq/2/pi, 20*log10(db2mag(171)*abs(squeeze(freqresp(HPFd*H(5,5),freq)))),'--','linewidth',2,'Color',clr(3,:))
% 
% 
% semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k')
% ylabel('$\left|{q_{1,j}}/{v_{2,j}}\right|$ [dB]','Interpreter','latex')
% legend('Pair 1','Pair 2','Pair 3','Pair 4')
% 
% 
% ax3 = nexttile
% semilogx(HL(3,3).Frequency/2/pi, rad2deg(phase(squeeze(HL(2,2).ResponseData))),'linewidth',2,'Color',clr(1,:))
% hold on
% semilogx(HL(3,3).Frequency/2/pi, rad2deg(phase(squeeze(HL(3,3).ResponseData))),'linewidth',2,'Color',clr(2,:))
% semilogx(HL(4,4).Frequency/2/pi, rad2deg(phase(squeeze(HL(4,4).ResponseData))),'linewidth',2,'Color',clr(3,:))
% semilogx(HL(5,5).Frequency/2/pi, rad2deg(phase(squeeze(-1*HL(5,5).ResponseData))),'linewidth',2,'Color',clr(4,:))
% semilogx(freq/2/pi, rad2deg(phase(-1*squeeze(freqresp(HPFd*H(2,2),freq)))),'--','linewidth',2,'Color',clr(1,:))
% semilogx(freq/2/pi, rad2deg(phase(-1*squeeze(freqresp(HPFd*H(3,3),freq)))),'--','linewidth',2,'Color',clr(2,:))
% semilogx(freq/2/pi, rad2deg(phase(-1*squeeze(freqresp(HPFd*H(4,4),freq)))),'--','linewidth',2,'Color',clr(3,:))
% semilogx(freq/2/pi, rad2deg(phase(-1*squeeze(freqresp(HPFd*H(5,5),freq)))),'--','linewidth',2,'Color',clr(4,:))
% 
% semilogx([1 1e3],[0 0],'--','linewidth',1,'Color','k')
% ylim([-30 30])
% ylabel('$\angle\left({q_{1,j}}/{v_{2,j}}\right)$ [deg]','Interpreter','latex')
% % 
% % linkaxes([ax1 ax2 ax3],'x')
% xlim([1 1000])
% xlabel('Frequency [Hz]','Interpreter','latex')
%% Try to match modal model
H2 = beamSSfunExp(20);
%%
figure()
for n = 2:5
    if n == 5
bode(-HL(n,n))
    else 
        bode(HL(n,n))
    end
hold on
end
xlim([5 1000])
set(findall(gcf,'type','line'),'linewidth',2)
%%
for n = 1:size(H2,1)-1
H02(n,n) = real(freqresp(H2(sen(n+1),act(n+1)),0*pi*2));
end

wp =20*2*pi;
Kp = 0.5; % max gain 2.3
zp = 0.05;
for n = 1:size(H2,1)-1
PPF2(n,n) = inv(H02(n,n))*Kp*tf([1],[1/wp^2 2*zp/wp 1+Kp])*tf([1 0],[1 2*pi*1]);
% PPFd(n,n) = c2d(PPF(n,n)*HPF,1e-4,'tustin');
PPF(n,n).InputDelay = 1e-4;
PPF2(n,n).InputName = sen(n+1);
PPF2(n,n).OutputName = act(n+1);
end
T2 = feedback(H2,PPF2,1,'name');

fig=figure('units','centimeters');
fig.Position = [1 1 19 15];
semilogx(HL(1,1).Frequency/2/pi, 20*log10(abs(squeeze(HL(1,1).ResponseData))),'linewidth',2,'Color',clr(1,:))
hold on
semilogx(HCL20.Frequency/2/pi, 20*log10(abs(squeeze(HCL20.ResponseData))),'linewidth',2,'Color',clr(2,:))


% semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H(1,1),freq)))),'linewidth',2,'Color',clr(3,:))
semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(H2(1,1),freq)))),'--','linewidth',2,'Color',clr(3,:))
% semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(T(1,1),freq)))),'linewidth',2,'Color',clr(4,:))

semilogx(freq/2/pi, 20*log10(abs(squeeze(freqresp(T2(1,1),freq)))),'linewidth',2,'Color',clr(4,:))
semilogx(wp/2/pi*[1 1],[-30 30],'--','linewidth',1,'Color',clr(7,:),'HandleVisibility','off')
semilogx(wp/2/pi*sqrt(1+Kp)*[1 1],[-30 30],'--','linewidth',1,'Color',clr(7,:),'HandleVisibility','off')
