%% Identification sampling 25kHz, ident up to 5kHz
fs = 5000;%5000
ts = 1/fs;

% load('IdentData25kHzV2.mat')
inpt = MeasData{2}.Values.Data(:);
outpt = -1*MeasData{1}.Values.Data(:);
time_in = MeasData{2}.Values.Time(:);
time_out = MeasData{1}.Values.Time(:);

figure()
plot(outpt,'.')
hold on
plot(inpt,'.')
legend('out','in')
grid on
%% check the time period
tsident = time_in(2:end)-time_in(1:(end-1));
% the data is sent in blocks of 800
figure()
patch([0 0 length(tsident) length(tsident)],[ts/1.001 ts*1.001 ts*1.001 ts/1.001],[0.9 0.9 0.9],'FaceAlpha',.5,'EdgeAlpha',0)
hold on
plot(tsident,'.')
%% Frequency response
f = logspace(0,log10(1e3),5e2);
[Tcl,f] = tfestimate(inpt,outpt,[],[],f,fs);
[cxy,f] = mscohere(inpt,outpt,[],[],f,fs);
data = frd(Tcl,2*pi*f,ts);
cohere = frd(cxy,2*pi*f,ts);
% load('G.mat')
%%
opts = bodeoptions('cstprefs');
opts.FreqUnits = 'Hz';
opts.XLim= [1 5e3];
% opts.PhaseVisible = 'on';
opts.Grid = 'on';

optsCoh = bodeoptions('cstprefs');
optsCoh.FreqUnits = 'Hz';
optsCoh.XLim= [1 5e3];
optsCoh.Grid = 'on';
optsCoh.PhaseVisible = 'off';
optsCoh.MagUnits = 'abs';

figure()
% bode(G,opts)
hold on
bode(data,opts)
legend('tf Matlab','Simulink')
grid on

figure()
bode(cohere,optsCoh)
grid on
%%
% save('IdentFR25kHzV2','Tcl','cxy','f')
%% Identify
% load('IdentFR25kHzV2.mat')
data = frd(-Tcl,2*pi*f,ts);
np = 14;
nz = 13;
iodelay = 2*ts; % one sample of delay = ts
weight = zeros(size(f));
weight(f>= 10 & f<=5000) = 1;
wmode = 10;
weight(f>= 10 & f<=40) = 2.5;
weight(f>= 100 & f<=160) = 4;
weight(f>= 250 & f<=450) = 15;
weight(f>= 600 & f<=2000) = 4;
wdata = frd(weight,2*pi*f,ts);
opt = tfestOptions('WeightingFilter',2*pi*weight.','Display','on','SearchMethod','auto','EnforceStability',true); % 'SearchMethod','lsqnonlin' % options for continuos-time model
opt.SearchOptions.MaxIterations = 1000;
% opt.SearchOptions.Tolerance = 1e-5;
Gnew = tfest(data,np,nz,iodelay, opt)
%%
Gd = c2d(ss(Gnew),ts,'tustin');

figure()
bode(data,opts)
hold on
bode(Gnew,opts)
bode(Gd,opts)
bode(wdata,opts)
bode(tf([1],[1],'OutputDelay',2*ts),2*pi*logspace(1,4,1e3), opts)


legend('data','G identified','G discrete')
grid on
%%
% G = Gnew;
% save('G','G')