%% FracNPFtuningExp
clear all
close all 
clc
% define plant
load('G.mat');
Gideal = G;
% load('Gideal.mat')
Wall = imag(eig(Gideal));
Wall = Wall(Wall>0);
W = Wall(end-1);
k = 1/abs(freqresp(Gideal,0));
G = Gideal; % be carefull, outside this code G reffers to the continuous model with high-pass low-frequency behaviour
fs = 25000; 
ts = 1/fs;
%%
% figure()
% bode(Gideal)
% hold on
% set(findall(gcf,'type','line'),'linewidth',2)


% alpha-sweep for the controller
% alpharange = [0.5,0.6,0.7,0.8,0.9,1];
% alpharange = [0.5,0.75,1];
alpharange = 0.7;
% relevant range of frequencesi
w = logspace(1,5,1e4);
s = 1i*w;

% load('funz.mat')
%% Tuning
% To create the controller we start with the frequency response on a grid
% of frequencies, then we create a corresponding ss with ssest, finally, we
% digitalize the obtained ss

QdB = 10;
Q = db2mag(QdB);
for n = 1:length(alpharange)
% controller paramaters
alpha = alpharange(n);
% K = max(2*alpha^0.28/Q^2,2/Q*(1.5-alpha)^3);
K = 0.1;
kf = K*k;
% K = kf/k;
f = min(1/sqrt(2)*(2.0 + 1.0.*K).^(1/2),(2+(-1-2*(alpha-1)).*K).^0.5./sqrt(2)+2*(1-alpha).^2);
% zf = max(0, 0.6164*K.^0.5+0.1*K.^2+2*alpha-2);
zf = -0.3;
% if alpha == 1
%     zf = (z1(K)+z2(K))/2;
% end
wf = f*W;
% create the controller

% These two functions are unstable in the digital domain - check
% marinangeli
% SD = croneFD(alpha, 1e3, 1e5, 3); % approximation of s^alpha using CRONE method 
% SD2 = croneFD(2*alpha, 1e3, 1e5, 3); % approximation of s^alpha using CRONE method 

% H(n) = kf*SD^2/wf^(2*alpha)/(SD^2/wf^(2*alpha)+2*zf*SD/wf^alpha+1);
% H(n) = kf*SD2/wf^(2*alpha)/(SD2/wf^(2*alpha)+2*zf*SD/wf^alpha+1);

% %% Convert to a proper ss-system
Hresp = kf*(s./wf).^(2*alpha)./((s./wf).^(2*alpha)+2*zf*(s./wf).^(alpha) +1);
data = frd(Hresp,w);
% weight = zeros(size(data.frequency));
% weight = zeros(size(f));
% weight(f>= 10 & f<=875) = 1;
% wmode = 10;
% weight(f>= 10 & f<=40) = 2.5;
% weight(f>= 100 & f<=160) = 4;
% weight(f>= 250 & f<=450) = 10;
% weight(f>= 600 & f<=850) = 10;
nx = 8; %order of the approximation
opt = tfestOptions('WeightingFilter',2*pi*[1,5e3],'Display','on','SearchMethod','auto','EnforceStability',true); % 'SearchMethod','lsqnonlin' % options for continuos-time model
opt.SearchOptions.MaxIterations = 20;
% opt.SearchOptions.Tolerance = 1e-5;
H(n) = ssest(data,nx,opt);
% T(n) = G/(1+G*H(n));
% S(n) = 1/(1+G*H(n));
% GH(n) = G*H(n);
end
%% Prepare for implementation, verify
LP = ss(tf([1],[1/5e4/2/pi 1]));
LPd = c2d(LP,ts,'tustin');
for n = 1:length(alpharange)
Hd(n) = c2d(H(n)*LP*LP,ts,'tustin');
end
save('Hd','Hd');
%% Verify the controller
opts = bodeoptions('cstprefs');
opts.FreqUnits = 'Hz';
opts.XLim= [1 5e3];
% opts.PhaseVisible = 'on';
opts.Grid = 'on';

figure()
bode(data,opts)
hold on
bode(H(1),opts)
bode(Hd(1),opts)
bode(LPd,opts)
legend('ideal','H','Hd','LPd')
grid on
%% Verify the open loop
% load('Gd.mat')
load('G.mat')
Gd = c2d(ss(G),ts);
figure()
bode(G,opts)
hold on
bode(Gd,opts)
bode(Hd(1),opts)
bode(Hd(1)*Gd,opts)
bode(tf([1],[1],'OutputDelay',ts),2*pi*logspace(1,4,1e3), opts)
grid on
legend('G','Gd','Hd','Hd*Gd')
%%
clsys = feedback(Gd,Hd(1));
% isstable(clsys)
figure() 
step(clsys) % to check teh stability
%% plot close loop
figure()
bode(G,w)
hold on
for n = 1:length(alpharange)
bode(T(n),w)
hold on
leg{n} = ['alpha = ', num2str(alpharange(n))];
end
legend(['G',leg])
grid on
title(['T \alpha-sweep'])
% xlim([10^2,10^4])
set(findall(gcf,'type','line'),'linewidth',2)
%% plot open loop
figure()
bode(G,w)
hold on
for n = 1:length(alpharange)
bode(S(n),w)
bode(GH(n),w)
hold on
leg{2*n-1} = ['S \alpha = ', num2str(alpharange(n))];
leg{2*n} = ['GH \alpha = ', num2str(alpharange(n))];
end
legend(['G',leg])
grid on
title(['T \alpha-sweep'])
% xlim([10^2,10^4])
set(findall(gcf,'type','line'),'linewidth',2)
%% Run simulations -  by hand for now
%% Compare with a simulation 
inpt2 =  MeasData{1}.Values.Data;
inpt2 = squeeze(inpt2(1,:,:));
outpt2 = MeasData{2}.Values.Data;
% outpt2 = squeeze(outpt2(1,:,:));
time2 = MeasData{1}.Values.Time;
fs = 5000; ts = 1/fs;

f = logspace(0,4,1e3);
[Tcl,f] = tfestimate(inpt2,outpt2,[],[],f,fs);
data = frd(Tcl,2*pi*f,ts);

figure()
bode(G)
hold on
bode(T(1))
bode(data)
legend('G','tf Matlab','Simulink')