%% NPF design  - integer order 
% clear all
close all 
clc
% define plant
load('G.mat')
Gideal = G;
% load('Gideal.mat')
Wall = imag(eig(Gideal));
Wall = Wall(Wall>0);
W = min(Wall);
k = 1/abs(freqresp(Gideal,0));
G = Gideal; 

% alpha-sweep for the controller
alpha = 1; % only one, not alpha range
% relevant range of frequencesi
w = logspace(1,5,1e4);
s = 1i*w;
fs = 25000; ts = 1/fs;
% load('funz.mat')
%% for UC meeting
W = 466;
k = 1;
%%
QdB = 10;
Q = db2mag(QdB);
% calculate the parameters
% K = max(2*alpha^0.28/Q^2,2/Q*(1.5-alpha)^3);
K = 0.8;
kf = K*k;
% K = kf/k;
f = min(1/sqrt(2)*(2.0 + 1.0.*K).^(1/2),(2+(-1-2*(alpha-1)).*K).^0.5./sqrt(2)+2*(1-alpha).^2);
% f = 0.9*f;
zf = max(0, 0.6164*K.^0.5+0.1*K.^2+2*alpha-2);
if alpha == 1
    zf = (z1(K)+z2(K))/2;
end
wf = f*W;
% create the controller
H1 = tf([kf/wf^2 0 0],[1/wf^2 2*zf/wf 1]);
LP = tf([1],[1/400 1]);
% H(n) = kf*SD^2/wf^(2*alpha)/(SD^2/wf^(2*alpha)+2*zf*SD/wf^alpha+1);

T1 = G/(1+G*H1);
S1 = 1/(1+G*H1);
GH1 = G*H1;
%% plot close loop
figure()
bode(G,w)
hold on
bode(T1,w)
bode(S1,w)
bode(GH1,w)
bode(H1,w)
legend('G','T1','S1','GH1','H1')
grid on
title(['Closed and open-loop, \alpha = 1'])
% xlim([10^2,10^4])
set(findall(gcf,'type','line'),'linewidth',2)
%% Prepare for simulation
% sample frequency and time
fs = 5000; ts = 1/fs;
H1ss = ss(H1);
Hd1 = c2d(H1ss,ts,'tustin');
save('Hd1','Hd1');
load('Gd.mat')
clsys = feedback(Gd,Hd1)
% isstable(clsys)
figure() 
step(clsys) % to check teh stability

figure()
bode(H1)
hold on
bode(Hd1)
%% Compare with a simulation 
inpt2 =  MeasData{1}.Values.Data;
inpt2 = squeeze(inpt2(1,:,:));
outpt2 = MeasData{2}.Values.Data;
% outpt2 = squeeze(outpt2(1,:,:));
time2 = MeasData{1}.Values.Time;
fs = 1e5; ts = 1/fs;
%
figure()
plot(time2(2:end)-time2(1:(end-1)),'.')
hold on
plot([1,length(time2)-1],[1e-5,1e-5],'--','linewidth',2)
plot([1,length(time2)-1],[1e-4,1e-4],'--','linewidth',2)
ylim([8e-6,1.2e-4])
xlim([1,length(time2)-1])
grid on
legend('measured','desired','min safe')
title('Communication period analysis')
%%
f = logspace(0,log10(2e3),1e3);
[Tcl,f] = tfestimate(inpt2,outpt2,[],[],f,fs);
data = frd(Tcl,2*pi*f,ts);
%%
% load('G.mat')
figure()
bode(G)
hold on
bode(data)
legend('tf Matlab','Simulink')