import numpy as np

"""
This file contains extra utility functions that are used in various files.
"""

def pad_with(vector, pad_width, iaxis, kwargs):
    """
    A utility method for padding the edges of an array.
    Taken from: https://numpy.org/doc/stable/reference/generated/numpy.pad.html
    """
    pad_value = kwargs.get('padder', 0)
    vector[:pad_width[0]] = pad_value
    vector[-pad_width[1]:] = pad_value

def fix_reading(image):
    """
    This function exists because for some reason reading a binarized image (that was binarized correctly) results
    in some 254 and 1 values. So these are brought to their correct values with this method.
    """
    image = np.where(image == 254, 255, image)
    image = np.where(image == 1, 0, image)
    return image

