import argparse
import cv2
import numpy as np
from local_methods.Bolan_Su import Bolan_Su
from local_methods.Kamel_Zhao import Kamel_Zhao
from local_methods.Niblack import Niblack
from local_methods.Gatos import Gatos
from local_methods.SoftwareProject import SoftwareProject
from local_methods.Lantink import Lantink
from hybrid_methods.Rao_et_al import Rao_et_al
from global_methods.Otsu import Otsu
from global_methods.Mello_Costa import Mello_Costa
from global_methods.Kavallieratou import Kavallieratou
import os


def get_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--input_path", type=str, help="Path to the input image")
    arguments = parser.parse_args()
    return arguments

if __name__ == "__main__":

    args = get_args()
    file_path = args.input_path

    img = cv2.imread(file_path, cv2.IMREAD_GRAYSCALE)

    # Local
    kamel = Kamel_Zhao(img).binarize()
    cv2.imwrite("output.png", kamel)