import numpy as np
from local_methods.Sauvola import Sauvola
import cv2


class SoftwareProject:

    def __init__(self, image):
        """
        Initialization of the SoftwareProject class, that thresholds using a method developed in the previous watermark
        prototype developed during the software project (2023).
        :param image: the image to be thresholded.
        """
        self.image = image.astype(np.int64)

    def binarize(self):

        thresh = Sauvola(self.image).binarize(window_size=45, k=0.01)
        thresh = cv2.morphologyEx(thresh.astype(np.uint8), cv2.MORPH_CLOSE,
                                  kernel=cv2.getStructuringElement(cv2.MORPH_CROSS, (3,3)),
                                  iterations=3)
        return thresh
