import skimage.filters as Filters
import numpy as np

class Sauvola:

    def __init__(self, image):
        """
        Initialization of the Sauvola class, that thresholds using the method described by
        Sauvola and Pietikäinen (2000).
        :param image: the image to be thresholded.
        """
        self.image = image

    def binarize(self, window_size=41, k=0.01, r=None):
        """
        Implementation of thresholding as explained by Sauvola and Pietikäinen (2000).
        :param window_size: the window size that represents the size of the sliding window that is used.
        The default is 25.
        :param k: constant that represents a scaling factor. The default is 0.2.
        :param r: constant that is the normalization factor for the standard deviation. The default is none.
        :return: the thresholded image.
        """

        thresh_sauvola = Filters.threshold_sauvola(self.image, window_size=window_size, k=k, r=r)
        binary_sauvola = np.where((self.image < thresh_sauvola), 255, 0)
        return binary_sauvola