import skimage.filters as Filters
import numpy as np

class Niblack:

    def __init__(self, image):
        """
        Initialization of the Niblack class, that thresholds using the method described by Niblack (1986).
        :param image: the image to be thresholded.
        """
        self.image = image

    def binarize(self, window_size=41, k=0.1):
        """
        Implementation of thresholding as explained by Niblack (1986).
        :param window_size: the window size that represents the size of the sliding window that is used.
        The default is 25.
        :param k: constant that represents a scaling factor for the standard deviation of a window. The default is 0.2.
        :return: the binarized image.
        """

        thresh_niblack = Filters.threshold_niblack(self.image, window_size=window_size, k=k)
        binary_niblack = (self.image < thresh_niblack).astype(np.uint8)
        binary_niblack *= 255
        return binary_niblack