import skimage.filters as Filters
import numpy as np
import matplotlib.pyplot as plt


class Otsu:

    def __init__(self, image):
        """
        Initialization of the Otsu class, that thresholds using the method described by Otsu (1979)
        :param image: the image to be thresholded.
        """
        self.image = image

    def binarize(self):
        """
        Implementation of thresholding as explained by Otsu (1979)
        :return: the binarized image.
        """
        binary_otsu = (self.image < Filters.threshold_otsu(self.image)).astype(np.uint8)
        binary_otsu *= 255
        return binary_otsu
