import pandas as pd
import csv

"""
Calculates the median value of likert ratings for a set of participants for a specific image. This data
is specifically designed for the raw survey data that is formatted as a .csv file.
"""

def likert_key(value):
    if value == "Strongly Disagree":
        return 1
    elif value == "Disagree":
        return 2
    elif value == "Neutral":
        return 3
    elif value == "Agree":
        return 4
    elif value == "Strongly Agree":
        return 5
    else:
        raise Exception("Wrong Value: " + value)

if __name__ == "__main__":
    algs = ["Su", "Kamel", "Gatos", "Lantink", "Niblack", "Software Project", "Rao", "Mello", "Otsu"]
    data = pd.read_csv('Watermark Binarization Survey.csv')

    map = []

    # Goes through each image choice that the participants made
    for col in data.loc[:, data.columns.str.startswith('Choice')]:
        row = [col]
        for alg in algs:
            test = data.loc[(data[col] == alg)]
            index = data.columns.get_loc(col)
            # Sorts all the likert ratings (index + 2 indicates that these are from the second statement,
            # index + 1 would be the first statement).
            values = sorted(list(test.iloc[:, index + 2]), key=likert_key)
            # Finds the median
            if len(values) == 0:
                row.append("None")
            elif len(values) == 1:
                row.append(values[0])
            elif len(values) % 2 != 0:
                row.append(values[(len(values) // 2)])
            else:
                row.append(values[(len(values) // 2) - 1])
        map.append(row)
    map = list(zip(*map))

    # Outputs median results in a .csv file.
    with open('heat_map_statement_2.csv', 'w') as f:
        write = csv.writer(f)
        write.writerows(map)
