import csv
import numpy as np

"""
This takes all data from a certain .csv file (generated using evaluate.py) and calculates the mean
and standard deviation for each column (algorithm).
"""

if __name__ == "__main__":
    file_path = "test/synthetic_eval_test_mpm.csv"
    data = {"Gatos": [],
            "Kamel": [],
            "Lantink": [],
            "Mello": [],
            "Niblack": [],
            "Otsu": [],
            "Rao": [],
            "Software Project": [],
            "Su": []}

    with open(file_path, newline='') as file:
        reader = csv.reader(file)
        header = []
        for i, row in enumerate(reader):
            if i == 0:
                header = row
                continue

            for j in range(1, len(row)):
                data[header[j]].append(float(row[j]))

    for key in data:
        print(key)
        print("Mean: " + str(np.mean(np.array(data[key]))))
        print("Standard Deviation: " + str(np.std(np.array(data[key]))))
