import java.io.*;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/**
** This class is used to go through files in a folder and prints all images to a .txt file. It
** also goes through a text file and randomly samples a set of images, which are outputted to another .txt file.
**/
public class SampleWatermarks {

    public static void main(String[] args) {
//        File[] images = new File("WZ-II-389").listFiles();
        // File path for the txt with the full list of watermark paths available
        String txtPath = "raw_watermark_files.txt";
        // File path to the randomly sampled watermarks, taken from raw_watermark_files.txt
        String outPath = "watermark_samples.txt";
//        generateSamples(txtPath, 400, outPath);

    }

    // Traverses a set of files, and appends the path of all files ending with .jpg or .pdf into the txt file
    // specified at txtPath.
    public static void traverseFile(File[] files, String txtPath){
        int numfiles = 0;
        for(File filename : files){
            if(filename.isDirectory()) traverseFile(filename.listFiles(), txtPath);
            else{
                try(FileWriter fw = new FileWriter(txtPath, true);
                    BufferedWriter bw = new BufferedWriter(fw);
                    PrintWriter out = new PrintWriter(bw))
                {
                    String name = filename.toString();
                    if(name.endsWith(".jpg") || name.endsWith(".pdf")){
                        out.println(name);
                        numfiles++;
                    }
                } catch (IOException e) {
                    System.err.println(e);
                }
            }
        }
        System.out.println(numfiles);
    }

    // Generates a set of randomly sampled lines from the file at inPath, and outputs it to the file at outPath. numSamples
    // specifies the number of lines to sample. Note that one line in the txt file is one sample.
    public static void generateSamples(String inPath, int numSamples, String outPath){
        long lineCount = 0;
        try {
            lineCount = Files.lines(Paths.get(inPath)).count();
        }
        catch (Exception e) {
            System.err.println(e);
        }

        List<Integer> lines = IntStream.range(0, Math.toIntExact(lineCount)).boxed().collect(Collectors.toList());
        Collections.shuffle(lines);
        int[] samplesInts = new int[numSamples];
        for(int i = 0; i < numSamples; i++) samplesInts[i] = lines.get(i);
        Arrays.sort(samplesInts);
        System.out.println(Arrays.toString(samplesInts));

        String[] samples = new String[numSamples];

        try {
            File myObj = new File(inPath);
            Scanner reader = new Scanner(myObj);
            int lineIndex = 0;
            int sampleIndex = 0;
            while (reader.hasNextLine() && sampleIndex < numSamples) {
                String line = reader.nextLine();
                if(lineIndex == samplesInts[sampleIndex]) {
                    samples[sampleIndex] = line;
                    sampleIndex++;
                }
                lineIndex++;
            }
            reader.close();
        } catch (FileNotFoundException e) {
            System.out.println("An error occurred.");
            e.printStackTrace();
        }

        try(FileWriter fw = new FileWriter(outPath, true);
            BufferedWriter bw = new BufferedWriter(fw);
            PrintWriter out = new PrintWriter(bw))
        {
            for(int i = 0; i < numSamples; i++){
                out.println(samples[i]);
            }
        } catch (IOException e) {
            System.err.println(e);
        }

    }


}
