"""Basic run file to generate the figures of the manuscript"""
from petcluster import Multiplex

por = Multiplex()
por.load_data_json("material_links.json","steam_links.json","electricity_links.json",\
                   "node_data.json")

# COMPLEX NETWORK
# Create hairball figure of the cluster
# without including nodes outside of the cluster boundaries
ign = ['MRKT','PROD','WWT','ENVI','SPROD','WATER','AIR','HCT','STCK','SWT','CLW']
por.network.visualize_hairball(ignore_list=ign)


# PERFORMANCE
# Create carbon sankey diagram
ign_list=['U10','AIR']
proc_list = []
por.performance.carbon_sankey_v2(ignore_list=ign_list, process_list = proc_list ,cutoff = 15,\
                                 fig_width=1700,fig_height = 1000, fig_pad =47, title=False,\
                                 text_font=30, fig_thickness= 10, process_abrev = True)
# Create scattere figure of steam
por.performance.scatter_steam(ignore_list=['U2'],width = 1000, height= 1000, font_size=25)
# Create scatter figure of CO2 emissions
por.performance.scatter_co2(ignore_list=[], width=1000, height=1000, font_size=25)
