# Representative model of the petrochemical cluster in the Port of Rotterdam
Understanding the Level of Integration in Existing Chemical Clusters: Case Study in the Port of Rotterdam
Authors:  Michael Tan, Paola Ibarra-Gonzalez, Igor Nikolic, Andrea Ramirez Ramirez
DOI: 10.1007/s43615-024-00410-5
TU Delft, Faculty of Technology, Policy and Management, Department of Engineering, Systems and Services, Section of Energy and Industry
TU Delft, Faculty of Technology, Policy and Management, Department of Multi Actor Systems, Section of System Engineering
TU Delft, Faculty of Applied Sciences, Department of Chemical Engineering
Corresponding author: Michael Tan
Contact Information: m.d.tan@tudelft.nl 

## Introduction
This model includes all the data obtained from the Aspen Plus process models and their interconnections, and can directly be loaded in petcluster Python module.
To run the model, clone and install the petcluster Python module from https://github.com/michaeltan91/petcluster/tree/circular-economy-and-sustainability 

Running the included Python file will generate all the figures presented in the manuscript: 
```python
python run_por.py
```

The process data was collected from Aspen Plus V12 process models that were constructed at Delft University of Technology as part of project Unravel. 

## Data specific information
In the tables below, the definitions and units are shown per file. 

### material_links.json
| Field    | Content | Unit |
| -------- | ------- | ------- |
| source  | Node the link originates from |  N.A. |
| source_type | The layer of the multiplex the link originates from | N.A. |
| target    | Node the link is going to | N.A. |
| target_type | Layer of the multiplex the link is going to | N.A. |
| type | This data is not relevant to the functioning of the model | N.A. |
| source_stream | Name of the Aspen Plus stream the stream data is based on | N.A. |
| target_stream | Name of the Aspen Plus stream the stream data is based on | N.A. |
| mass_flow_rate | Mass flow rate of the stream | ktonne / y |
| mole_flow_rate| Mole flow rate of the stream | kmole/hr |
| volume_flow_rate| Volumetric flow rate of the stream | m3/hr |
| mass_fraction | Mass fraction of each component in the stream| ktonne/ktonne |
| mole_fraction | Mole fraction of each component in the stream| kmole/kmole |
| pressure | Pressure of the stream | Bar |
| temperature| Temperature of the stream | °C |
| carbon_content | Weight fraction of carbon in the stream | ktonne of Carbon / ktonne |
| carbon_flow_rate | Mass flow rate of carbon in the stream | ktonne of Carbon / y |
| liquid_fraction | Liquid fraction of the stream | N.A. |
| solid_fraction | Solid fraction of the stream | N.A. |
| vapor_fraction| Vapor fraction of the stream | N.A. |
| cluster_boundary | Indicates whether the stream crosses the boundary of the cluster | N.A. |\

### steam_links.json
| Field    | Content | Unit |
| -------- | ------- | ------- |
| source  | Node the link originates from |  N.A. |
| source_type | The layer of the multiplex the link originates from | N.A. |
| target    | Node the link is going to | N.A. |
| target_type | Layer of the multiplex the link is going to | N.A. |
| type | This data is not relevant to the functioning of the model | N.A. |
| energy_type| Which type of steam the link represents | N.A. |
| mass_flow_rate | Mass flow rate of the stream | ktonne / y |
| energy | The flow of energy in the link | TJ / y | 
| cluster_boundary | Indicates whether the stream crosses the boundary of the cluster | N.A. |

### electricity_links.json
| Field    | Content | Unit |
| -------- | ------- | ------- |
| source  | Node the link originates from |  N.A. |
| source_type | The layer of the multiplex the link originates from | N.A. |
| target    | Node the link is going to | N.A. |
| target_type | Layer of the multiplex the link is going to | N.A. |
| type | This data is not relevant to the functioning of the model | N.A. |
| energy_type| Which type of steam the link represents | N.A. |
| mass_flow_rate | Not  relevant for this stream type | N.A. |
| energy | The flow of energy in the link | TJ / y | 
| pressure | Not  relevant for this stream type | N.A. |
| temperature | Not  relevant for this stream type | N.A. | 
| cluster_boundary | Indicates whether the stream crosses the boundary of the cluster | N.A. |

### node_data.json
| Field | Content | Unit |
| -------- | ------- | ------- |
| source| Aspen Plus process model the data is based on | N.A. |
| type | Not  relevant for this data type | N.A. |
| name | Name of the node | N.A. |
| name_abbrev | Abbreviated name of the node if applicable | N.A. |
| energy_consumption | Energy consumption of the node per type of energy, a positive number indicates the node consumes that type of energy, for a negative number it indicates the process produces that type of energy | TJ/y |
| steam_usage | The steam consumption in mass flow rate per type of steam, positive number indicates the process consumes the steam, negative it produces that type of steam | ktonne / y |
| energy use | The steam use in energy flow rate and mass flow rate per type of steam | TJ / y ; ktonne / y |
| energy_production | The steam production in energy flow rate and mass flow rate per type of steam | TJ / y ; ktonne / y |
| auxiliary_materials | Stream data for the use of auxialiary materials (Natural gas, hydrogen, CO2, oxygen, or air) by the node.  For more information regarding the data fields of these streams, see the "material_links.json" table |
| area_footprint | This data is not relevant to the functioning of the model | N.A. | 
| equipment_cost | This data is not relevant to the functioning of the model | N.A. |
| company | The company the node is located within, indicated by a letter | N.A. |
| site | The cluster site the node is located within, indicated by a number| N.A. |
| CAPEX | The Capital expenditures that were required to construct the process | million € |
| harbor_process | This data is not relevant to the functioning of the model | N.A. |
| process_splittable | This data is not relevant to the functioning of the model | N.A. |
| opex | This data is not relevant to the functioning of the model | N.A. |
| stream_table | This data is not relevant to the functioning of the model | N.A. |
 

## Terms of use and citing:
The dataset may be used according to the CC-BY 4.0 license with mentioning of the following reference:

Tan M, Ibarra-Gonzalez P, Nikolic I, Ramirez Ramirez A. 2024. Data from: Understanding the Level of Integration in Existing Chemical Clusters: Case Study in the Port of Rotterdam. 4TU.Centre for Research Data. DOI: 10.4121/2103f9fb-2030-44a9-96f3-93a46ba2d545.
