# Conceptual model of factors affecing children's access to urban greenspaces

This repository contains three folders with files associated to the research paper "Children's access to urban greenspaces: a survey of factors and measures". This paper presents a conceptual model, created from generative workshops and a scoping literature review. 

- *Conceptual model* contains .pdf files with a visual conceptual model of factors, an overview of factors (not) accounted for in literature measures, and a revisited version of the original conceptual model (created after publication of the associated research paper, with minor additions based on follow-up research).
- *Workshop materials* contains the .pdf files with materials used during the generative workshops with researchers and practitioners, including forms to guide the process and a card deck with potentially relevant data sources to inform and inspire the participants.
- *Analysis* contains .xlsx files with the documentation of the scoping literature review process that led to the conceptual model, and the codebook with qualitative codes and associated information from the coding process in Atlas TI.

## Using this data?

If you use this data in your work, please cite the journal paper.

**Citation info:** Roos Teeuwen, Alessandro Bozzon, and Achilleas Psyllidis. Children's access to urban greenspaces: a survey of factors and measures. Cities & Health. 2024. DOI: https://doi.org/10.1080/23748834.2024.2387931 (in press).

**Abstract:** Access to greenspace impacts children’s physical, social, and mental health. Numerous factors affect children’s access to urban greenspaces, often distinct from those affecting the general population, including parental restrictions, limited routine activity-space, and particular preferences. Most accessibility measures, however, employ the same principles for children and the general population, and a comprehensive exploration of factors and corresponding measures remains lacking. We conduct a scoping review and workshops with researchers and practitioners to identify factors affecting children’s access to greenspace, synthesize them into a conceptual model, and assess how existing accessibility measures address these factors. We focus on children aged 6-11 years old. Our analysis indicates children’s access involves a trade-off between reachability, determined by the route connecting the child’s starting setting to greenspace, and attractiveness, determined by how the greenspace adheres to the child’s, and their companions’, preferences and motivations for visiting. Safety perceptions are important throughout. Existing accessibility measures predominantly emphasize reachability, neglecting personal characteristics and motivations. Based on our findings, we propose future directions for developing child-centered accessibility metrics. Our overview of metrics can facilitate decision-making in the selection of suitable measures, while our conceptual model can foster shared understanding of factors affecting children’s access to urban greenspace.

**Keywords:** Children, Urban Greenspace, Accessibility, Measurement, Conceptual Model
