import requests
import csv

# User-provided keywords to search Stack Overflow
keywords = input("Enter keywords to search Stack Overflow: ")

# API endpoint and parameters
url_search = "https://api.stackexchange.com/2.3/search/advanced"
url_questions = "https://api.stackexchange.com/2.3/questions"
url_answers = "https://api.stackexchange.com/2.3/answers"
# Gets all the articles on the site.
# To constrain articles returned to those with a set of tags, use the tagged parameter with a semicolon delimited list
# of tags. This is an and constraint, passing tagged=c;java will return only those articles with both tags. As such,
# passing more than 5 tags will always return zero results.
url_articles = "https://api.stackexchange.com/2.3/articles"
# This url displays all the communities that are present on Stack Overflow
url_collectives = "https://api.stackexchange.com/2.3/collectives"
# This url displays all the posts that have been posted on Stack Overflow
url_posts = "https://api.stackexchange.com/2.3/posts"
url_tags = "https://api.stackexchange.com/2.3/tags"
params1 = {
    "fromdate": "2017-01-01",
    "todate": "2023-05-31",
    "order": "desc",
    "sort": "relevance",
    "pagesize": 100,
    "title": keywords,
    "site": "stackoverflow",
    "tagged": "testing;tests;test;software-testing",
    "page": 1,
    "filter": "withbody",
}
params2 = {
    "fromdate": "2017-01-01",
    "todate": "2023-05-31",
    "order": "desc",
    "sort": "relevance",
    "pagesize": 100,
    "body": keywords,
    "site": "stackoverflow",
    "tagged": "testing;tests;test;software-testing",
    "page": 1,
    "filter": "withbody",
}

# # Send GET request to API endpoint
# response = requests.get(url_search, params=params1)
# print(response.url)
#
# # Parse JSON response
# data = response.json()
# has_more = data["has_more"]
# has_more_update = True
# items = data["items"]
#
# file_name = keywords.replace(" ", "-") + "-2017-title" + ".csv"
# with open(file_name, mode="w", encoding="utf-8", newline="") as csv_file:
#     fieldnames = ["title", "body", "link", "tags", "view_count" , "is_answered", "score", "answer_count"]
#     writer = csv.DictWriter(csv_file, fieldnames=fieldnames)
#     writer.writeheader()
#     while has_more_update:
#         for item in data["items"]:
#             # print(item)
#             try:
#                 writer.writerow({"title": item["title"], "body": item["body"], "link": item["link"], "tags": item["tags"],
#                                  "view_count": item["view_count"], "is_answered": item["is_answered"],
#                                  "score": item["score"], "answer_count": item["answer_count"]})
#             except (KeyError, TypeError):
#                 # Handle the case where the owner is not valid or the reputation is not available
#                 writer.writerow({"title": item["title"], "body": "", "link": item["link"], "tags": item["tags"],
#                                  "view_count": item["view_count"], "is_answered": item["is_answered"],
#                                  "score": 0, "answer_count": item["answer_count"]})
#         if has_more_update:
#             params1["page"] += 1  # Increment page number in the params dictionary
#             response = requests.get(url_search, params=params1)
#             data = response.json()
#             has_more_update = data["has_more"]

# Send GET request to API endpoint
response_title = requests.get(url_search, params=params1)
response_body = requests.get(url_search, params=params2)
print(response_title.url)
print(response_body.url)

# Parse JSON response
data_title = response_title.json()
data_body = response_body.json()
has_more_title = data_title["has_more"]
has_more_body = data_body["has_more"]
has_more_update_title = True
has_more_update_body = True
items_title = data_title["items"]
items_body = data_body["items"]

file_name = keywords.replace(" ", "-") + "-2017" + ".csv"
with open(file_name, mode="w", encoding="utf-8", newline="") as csv_file:
    fieldnames = ["title", "body", "link", "tags", "view_count", "is_answered", "score", "answer_count"]
    writer = csv.DictWriter(csv_file, fieldnames=fieldnames)
    writer.writeheader()
    while has_more_update_title:
        for item in data_title["items"]:
            try:
                writer.writerow(
                    {"title": item["title"], "body": item["body"], "link": item["link"], "tags": item["tags"],
                     "view_count": item["view_count"], "is_answered": item["is_answered"],
                     "score": item["score"], "answer_count": item["answer_count"]})
            except (KeyError, TypeError):
                # Handle the case where the owner is not valid or the reputation is not available
                writer.writerow({"title": item["title"], "body": "", "link": item["link"], "tags": item["tags"],
                                 "view_count": item["view_count"], "is_answered": item["is_answered"],
                                 "score": 0, "answer_count": item["answer_count"]})
        if has_more_update_title:
            params1["page"] += 1  # Increment page number in the params dictionary
            response_title = requests.get(url_search, params=params1)
            data_title = response_title.json()
            has_more_update_title = data_title["has_more"]

    while has_more_update_body:
        for item in data_body["items"]:
            try:
                writer.writerow(
                    {"title": item["title"], "body": item["body"], "link": item["link"], "tags": item["tags"],
                     "view_count": item["view_count"], "is_answered": item["is_answered"],
                     "score": item["score"], "answer_count": item["answer_count"]})
            except (KeyError, TypeError):
                # Handle the case where the owner is not valid or the reputation is not available
                writer.writerow({"title": item["title"], "body": "", "link": item["link"], "tags": item["tags"],
                                 "view_count": item["view_count"], "is_answered": item["is_answered"],
                                 "score": 0, "answer_count": item["answer_count"]})
        if has_more_update_body:
            params2["page"] += 1  # Increment page number in the params dictionary
            response_body = requests.get(url_search, params=params2)
            data_body = response_body.json()
            has_more_update_body = data_body["has_more"]