% This simple script retrieves the number of subsets in the domain, as well as their names, given *IND*.mat files

function [number_subsets, subset_names] = Subset_Retriever()
    %%% The subset files %%%
        subset_files = dir('*IND*.mat');
        number_subsets = length(subset_files);
        
        % The names of the subsets
        subset_names = cell(1, number_subsets);
        
        for s = 1 : number_subsets
            subset = subset_files(s).name;
            
            % They are given by the part after the final _, i.e. NAT_IND_FRA.mat
            subset_name_parts = strsplit(subset, '_');
            subset_name = subset_name_parts{end};
            subset_name = erase(subset_name, '.mat');
            
            subset_names{s} = subset_name;
        end
end