% This function equalises the length of the given time series, based on their dates
% TS_cell and file_dates_cell are expected to be of shape {TS_1, ..., TS_n}, where n = number_TS
% Number_files_list is expected to be of shape [n_f_1, ... n_f_n]

% Note: The temporal resolution of the given input data is assumed to be equal
% Note: The input TS may be of image or time series format

function [TS_cell, file_date_list, number_files, number_years, year_list] = Time_Series_Length_Equaliser(TS_cell, file_dates_cell, number_files_list, number_TS)
    %%% Determine the data format %%%
        data_format_cell = cell(1, number_TS);
        
        for n = 1:number_TS
            TS = TS_cell{n};
            number_files = number_files_list(n);
            
            % Determine whether the input is in time series or image format
            if length(TS{1}) == number_files
                data_format = 'TS';
            else
                data_format = 'IMG';
            end
            
            data_format_cell{n} = data_format;
        end

    %%% Limiting dates %%%
        % The date numbers are determined
        date_start_numbers = zeros(1, number_TS);
        date_end_numbers = zeros(1, number_TS);
        
        date_numbers_cell = cell(1, number_TS);
    
        for n = 1:number_TS
            file_date_list = file_dates_cell{n};
            number_files = number_files_list(n);
            
            % The numberical dates of this time series
            date_numbers_list = zeros(1, number_files);
            
            for k = 1:number_files
                date = file_date_list{k};
                date_number = datenum(date, 'dd.mm.yyyy');

                date_numbers_list(k) = date_number;     
            end
            
            date_numbers_cell{n} = date_numbers_list;
            
            date_start = date_numbers_list(1);
            date_start_numbers(n) = date_start;
            
            date_end = date_numbers_list(number_files);
            date_end_numbers(n) = date_end;
        end

        % The limiting dates are selected
        date_start = max(date_start_numbers);
        date_end = min(date_end_numbers);
        
    %%% The data outside of these bounds is removed %%%    
        for n = 1:number_TS
            date_numbers_list = date_numbers_cell{n};
            data_format = data_format_cell{n};
            
            % First and final indices
            diff_start = abs(date_numbers_list - date_start);
            ind_start = find(diff_start == min(diff_start));
            
            diff_end = abs(date_numbers_list - date_end);
            ind_end = find(diff_end == min(diff_end));
            
            % The data is shortened
            TS = TS_cell{n};
            
            if strcmp(data_format, 'IMG')
                TS = TS(ind_start : ind_end);
            elseif strcmp(data_format, 'TS')
                [rows_data, columns_data] = size(TS);
                
                for i = 1:rows_data * columns_data
                    TS_n = TS{i};
                    TS_n = TS_n(ind_start : ind_end);
                    TS{i} = TS_n;
                end
            end
            
            TS_cell{n} = TS;
            
            % The shortened file_date_list is created
            if n == 1
                file_date_list = file_dates_cell{n};
                file_date_list = file_date_list(ind_start : ind_end);
                number_files = length(file_date_list);
            end
        end

    %%% Years the data covers %%%
        date_start = strsplit(file_date_list{1}, '.');
        year_start = str2double(date_start{3});

        date_end = strsplit(file_date_list{number_files}, '.');
        year_end = str2double(date_end{3});

        year_list = year_start : year_end;
        number_years = length(year_list);
end





