% This script spatially coarsens geotiff data, and if desired, outputs new geotiff files at the lower resolution

function [Coarsened_IMG_data_cell] = Spatial_Data_Coarsener(Data_type, coarsening_factor, Save_data)

    %%% The data files %%%
        file_list = dir(sprintf('%s*.tif*', Data_type));
        number_files = length(file_list);
    
    %%% Coarsening %%%
        Coarsened_IMG_data_cell = cell(1, number_files);
    
        % Parallel loop
        parfor k = 1 : number_files
            file_name = file_list(k).name;

            % Read the data
            [data, R] = geotiffread(file_name);
            info = geotiffinfo(file_name);

            % Coarsen it and change R
            data = data(1 : coarsening_factor : end, 1 : coarsening_factor : end);
            R.RasterSize = size(data);

            % Append the coarsened data
            Coarsened_IMG_data_cell{k} = data;
            
            % Write the new files     
            if strcmp(Save_data, 'Yes')
                % Determine whether it's .tif or .tiff
                file_parts = strsplit(file_name, '.');
                file_type = file_parts{end};
                
                % The geokey tag
                Tag = info.GeoTIFFTags.GeoKeyDirectoryTag;
                
                file_name = erase(file_name, ['.', file_type]);
                geotiffwrite(file_name, data, R, 'GeoKeyDirectoryTag', Tag);
                
                % An extra f is added
                if strcmp(file_type, 'tiff')
                    movefile([file_name, '.tif'], [file_name, '.tiff']);
                end
            end
        end    
        
        fprintf('All of the %s data has been coarsened by factor %g \n', Data_type, coarsening_factor);
end