% This script applies standard oversampling to the given data
% Beta is the ratio to which the classes are balanced

function [Ground_Truth_Data_list_total, Feature_data_matrix_total, number_oversampling_list] = Oversampler(Ground_truth_data_list, class_values, Feature_data_matrix, Beta, number_classes, number_samples_list, class_samples_cell)
    
    % List of the number of samples to be added to each class
    number_oversampling_list = zeros(1, number_classes);

    for c = 1:number_classes
       number_oversampling_list(c) = round(Beta*(max(number_samples_list) - number_samples_list(c)));
    end
        
    % Samples are duplicated
    Oversampled_classes_cell = cell(1, number_classes);
    Oversampled_feature_data_cell = cell(1, number_classes);

    for c = 1:number_classes
        number_oversampling = number_oversampling_list(c);

        % Random samples are selected to be duplicated
        class_samples = class_samples_cell{c};
        random_class_samples = datasample(class_samples, number_oversampling);

        % The oversampled data
        class = class_values(c);
        oversampled_classes_list = class * ones(number_oversampling, 1);
        oversampled_feature_data = Feature_data_matrix(random_class_samples, :);

        Oversampled_classes_cell{c} = oversampled_classes_list;
        Oversampled_feature_data_cell{c} = oversampled_feature_data;
    end

    % Combine the oversampled feature and class data
    Oversampled_classes_data = vertcat(Oversampled_classes_cell{:});
    Oversampled_feature_data = vertcat(Oversampled_feature_data_cell{:});
    
    % The total data
    Ground_Truth_Data_list_total = [Ground_truth_data_list; Oversampled_classes_data];
    Feature_data_matrix_total = [Feature_data_matrix; Oversampled_feature_data];
    
end