% This script merges the confusion matrices of the chunks

function Confusion_Matrix_Merger(number_chunks_x, number_chunks_y, class_names, number_classes, zero_string, chunk_deletion)
%%% The years for which confusion matrices exist are determined %%%
    CM_list = dir('CM*x*y*.mat');
    
    % This is done by counting the number of files for the first chunk
    CM_file = CM_list(1).name;
    CM_file_parts = strsplit(CM_file, '_');
    chunk_string = CM_file_parts{3};
    chunk_string = erase(chunk_string, '.mat');
    
    CM_year_list = dir(sprintf('CM_*_%s.mat', chunk_string));
    
    number_years = length(CM_year_list);
    year_cell = cell(1, number_years);
    
    for y = 1:number_years
        CM_file = CM_year_list(y).name;
        CM_file_parts = strsplit(CM_file, '_');
        year = CM_file_parts{2};
        
        year_cell{y} = year;
    end    

%%% The confusion matrices are merged %%%
    CM_matrix = zeros(number_classes);

    for y = 1:number_years
        year = year_cell{y};
        
        for c_x = 1:number_chunks_x     
            for c_y = 1:number_chunks_y

                % String to identify this chunk, and the data produced with it        
                s_x = num2str(c_x, zero_string);
                s_y = num2str(c_y, zero_string);

                chunk_string = sprintf('x%sy%s', s_x, s_y);
                
                % Confusion matrix of this partition
                file_name = sprintf('CM_%s_%s.mat', year, chunk_string);

                CM_file = load(file_name);
                CM_matrix_chunk_data = CM_file.confusion_matrix;

                CM_matrix_chunk = CM_matrix_chunk_data.NormalizedValues;
                CM_labels_chunk = CM_matrix_chunk_data.ClassLabels;
                
                % The confusion matrix data is appended
                number_classes_chunk = length(CM_labels_chunk);
                
                for i = 1:number_classes_chunk
                    class_i = CM_labels_chunk{i};

                    % Determine which index of the classes, this class belongs to
                    for c = 1:number_classes
                        if strcmp(class_names{c}, class_i)
                            class_ind_i = c;
                        end
                    end
                    
                    for j = 1:number_classes_chunk
                        class_j = CM_labels_chunk{j};
                        
                        % Determine which index of the classes, this class belongs to
                        for c = 1:number_classes
                            if strcmp(class_names{c}, class_j)
                                class_ind_j = c;
                            end
                        end
                        
                        % The number of samples is added to the total matrix
                        CM_value = CM_matrix_chunk(i, j);
                        CM_matrix(class_ind_i, class_ind_j) = CM_matrix(class_ind_i, class_ind_j) + CM_value;
                    end
                end                    
            end
        end
                
        % Create a figure of the merged confusion matrix
        
        figure(1)
        % Set the size and white background color
        set(gcf, 'Units', 'Normalized', 'Position', [0 0 1 1]);
        set(gcf, 'color', [1, 1, 1]);
        
        confusion_matrix_total = confusionchart(CM_matrix, class_names);
        sortClasses(confusion_matrix_total, class_names);
        confusion_matrix_total.RowSummary = 'row-normalized';
        confusion_matrix_total.ColumnSummary = 'column-normalized'; 
        confusion_matrix_total.Title = ''; 

        set(gca, 'FontSize', 25);
        
        % Save the merged confusion matrix
        CM_name = sprintf('CM_%s', year);
        
        try
            export_fig([CM_name, '.png'])
        catch
            frame = getframe(1);
            im = frame2im(frame);
            [imind, cm] = rgb2ind(im, 256);
            imwrite(imind, cm, [CM_name, '.png']);
        end
        
        save([CM_name, '.mat'], 'confusion_matrix_total');
        
        close(1)
    end
    
%%% Remove the CM files of the chunks %%%
    if strcmp(chunk_deletion, 'On')
        delete('CM*x*y*.mat');
    end
end
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    