% This script determines the temporal classification results in each country independently and of the full data set

clear all
close all
clc

%%% Required files %%%
    % TYPE                      NUMBER              NAME
    % ---------------------------------------------------------------------------------------------------------------
    % National indices:         1 per region        NAT_IND_***.mat
    % Smoothed LC data:         number_years        SLC_YYYY_Full.tif
    % Class values:             1                   grouped_classes.txt
    
%%% Inputs %%%
    % The degree of coarsening of the land cover data
    Resolution_downscaling      = 'Off';    % [On, Off]
    coarsening_factor           = 10;        % Scalar
    
    % Whether the original or the smoothed land cover data should be used
    Smoothed                    = 'Yes';    % [Yes, No]
    
    % If water bodies are not included, the class distribution is calculated only taking the other classes into account
    Include_water               = 'No';    % [Yes, No]
    
    % If the bounds of the domain should be considered or not
    Bounds                      = 'No';    % [Yes, No]
    
%%% Read the data %%%    
    % Land cover data
    tic;
    [class_data_cell, number_classes, class_names, class_values, RGB_codes] = DTC_Class_Data(Resolution_downscaling, coarsening_factor, Smoothed, 'Corine', [], [], [], []);
    t_class_read = toc;
    
    fprintf('   Retrieving the class data took %f seconds \n', t_class_read);
    
    % Size of the data
    if strcmp(Smoothed, 'Yes')
        [rows_data, columns_data, number_files, R] = Size_Reader('SLC', 'geotiff');     
    elseif strcmp(Smoothed, 'No')
        [rows_data, columns_data, number_files, R] = Size_Reader('LC', 'geotiff');
    end

    % Subdomain indices
    tic;
    [subdomain_indices_cell, subdomain_code_cell, number_subdomains] = Subdomain_Indices_Reader_P(Resolution_downscaling, coarsening_factor, rows_data, columns_data);
    t_nat_ind = toc;
    
    fprintf('   Retrieving the subdomain indices took %f seconds \n', t_nat_ind);
    
%%% Determine the temporal classification results %%%
    tic;
    [year_list, number_years, subdomains_class_proportion_cell, subdomains_delta_proportion_cell, subdomains_relative_delta_class_cell] = Temporal_Class_Distribution(Resolution_downscaling, coarsening_factor, rows_data, columns_data, number_files, class_data_cell, number_classes, class_names, class_values, RGB_codes, subdomain_indices_cell, subdomain_code_cell, number_subdomains, R, Bounds, Include_water);    
    t_class_results = toc;
    
    fprintf('   Determining the temporal land cover results took %g seconds \n', t_class_results);
    
    % Free memory
    clear class_data_cell
    
    tic;
    Temporal_Distribution_Figures(rows_data, columns_data, number_classes, class_names, year_list, number_years, subdomains_class_proportion_cell, subdomains_delta_proportion_cell, subdomains_relative_delta_class_cell, Bounds, Include_water);
    t_maps = toc;
    
    fprintf('   Creating maps of the results took %g seconds \n', t_maps);
    