% This script computes the sensitivity of the classifier to outdated training data by checking whether it has succesfully detected changed indices

clear all
close all
clc

%%% Inputs %%% 
    % Resolution at which the results are assessed
    Resolution_downscaling  =   'Off';
    coarsening_factor       =   5;
    
    % The year of the outdated CLC data set used to train the classifier, as well as the actual year
    CLC_year_outdated       = 2006;
    CLC_year_actual         = 2012;
    
%%% Corine data %%%
    [CLC_data_outdated, number_classes, class_names, class_values, ~] = Corine_Class_Data(Resolution_downscaling, coarsening_factor, CLC_year_outdated, 'Off', 'Colorbrewer', [], [], [], []);
    [CLC_data_actual, ~, ~, ~, ~] = Corine_Class_Data(Resolution_downscaling, coarsening_factor, CLC_year_actual, 'Off', 'Colorbrewer', [], [], [], []);
        
%%% Classified land cover data %%%
    [LC_data_cell, ~, ~, ~, ~] = DTC_Class_Data(Resolution_downscaling, coarsening_factor, 'No', 'Colorbrewer');
    
    LC_data_outdated = LC_data_cell{1};
    LC_data_actual   = LC_data_cell{2};
    
%%% The indices for which the Corine data has changed %%%
    similarity = CLC_data_actual == CLC_data_outdated;
    ind_changed = find(similarity == 0);

    CLC_data_changed = CLC_data_actual(ind_changed);
    LC_data_outdated_changed = LC_data_outdated(ind_changed);
    LC_data_actual_changed = LC_data_actual(ind_changed);
    
    % Missing indices are removed
    missing_ind = find(CLC_data_changed == 999);
    
    CLC_data_changed(missing_ind) = [];
    LC_data_outdated_changed(missing_ind) = [];
    LC_data_actual_changed(missing_ind) = [];
    
%%% Confusion matrices for these changed indices %%%
    % Outdated training data
    class_values_present = unique([CLC_data_changed, LC_data_outdated_changed]);
    number_classes_present = length(class_values_present);

    class_names_present = cell(1, number_classes_present);

    for v = 1:number_classes_present
        class_value = class_values_present(v);
        class_ind = class_values == class_value;

        class_name = class_names{class_ind};
        class_names_present{v} = class_name;
    end

    % The confusion matrix data            
    figure(1)
    confusion_matrix_total = confusionchart(CLC_data_changed, LC_data_outdated_changed);
    confusion_matrix_data = confusion_matrix_total.NormalizedValues;
    close(1)

    % Figure, where the class values are replaced with the names of the classes
    figure(1)

    confusion_matrix_total = confusionchart(confusion_matrix_data, class_names_present);
    confusion_matrix_total.RowSummary = 'row-normalized';
    confusion_matrix_total.ColumnSummary = 'column-normalized'; 
    confusion_matrix_total.Title = ''; 

    % Set the size and white background color
    set(gcf, 'Units', 'Normalized', 'Position', [0 0 1 1]);
    set(gcf, 'color', [1, 1, 1]);

    set(gca, 'FontSize', 25);

    % Save the figure, s.t. the accuracy of the land cover classification can be investigated in more detail
    CM_name = sprintf('CM_%g_%g', CLC_year_actual, CLC_year_outdated);

    try
        export_fig([CM_name, '.png'])
    catch
        frame = getframe(1);
        im = frame2im(frame);
        [imind, cm] = rgb2ind(im, 256);
        imwrite(imind, cm, [CM_name, '.png']);
    end

    % Save the confusion matrix
    save([CM_name, '.mat'], 'confusion_matrix_total');

    close(1)

    % Outdated training data
    class_values_present = unique([CLC_data_changed, LC_data_actual_changed]);
    number_classes_present = length(class_values_present);

    class_names_present = cell(1, number_classes_present);

    for v = 1:number_classes_present
        class_value = class_values_present(v);
        class_ind = class_values == class_value;

        class_name = class_names{class_ind};
        class_names_present{v} = class_name;
    end

    % The confusion matrix data            
    figure(2)
    confusion_matrix_total = confusionchart(CLC_data_changed, LC_data_actual_changed);
    confusion_matrix_data = confusion_matrix_total.NormalizedValues;
    close(2)

    % Figure, where the class values are replaced with the names of the classes
    figure(2)

    confusion_matrix_total = confusionchart(confusion_matrix_data, class_names_present);
    confusion_matrix_total.RowSummary = 'row-normalized';
    confusion_matrix_total.ColumnSummary = 'column-normalized'; 
    confusion_matrix_total.Title = ''; 

    % Set the size and white background color
    set(gcf, 'Units', 'Normalized', 'Position', [0 0 1 1]);
    set(gcf, 'color', [1, 1, 1]);

    set(gca, 'FontSize', 25);

    % Save the figure, s.t. the accuracy of the land cover classification can be investigated in more detail
    CM_name = sprintf('CM_%g_%g', CLC_year_actual, CLC_year_actual);

    try
        export_fig([CM_name, '.png'])
    catch
        frame = getframe(1);
        im = frame2im(frame);
        [imind, cm] = rgb2ind(im, 256);
        imwrite(imind, cm, [CM_name, '.png']);
    end

    % Save the confusion matrix
    save([CM_name, '.mat'], 'confusion_matrix_total');

    close(2)
    
    
    