# -*- coding: utf-8 -*-
"""
Created on Mon Feb 27 11:53:58 2023

@author: lmveldman
"""

import os
import sys
import inspect

### CHANGING TO CORRECT DIRECTORY
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
grandparentdir = os.path.dirname(parentdir)
sys.path.insert(0, grandparentdir) 

from data_analysis_functions import *
from simulation_functions_v3 import *


### DEFINING SPIN PARAMETERS ###
espin = 1/2 # electron spin
nspin = 5/2 # nuclear spin
edim = int(2*espin+1) # dimension of electron spin space
ndim = int(2*nspin+1) # dimension of nuclear spin space
dim = edim*ndim
electron = [spin_Jx(espin),spin_Jy(espin),spin_Jz(espin)] # electron spin vector
nucleus = [spin_Jx(nspin),spin_Jy(nspin),spin_Jz(nspin)] # nuclear spin vector
eI = qeye(edim) #identity
nI = qeye(ndim) #identity

### DEFINING HAMILTONIAN PARAMETERS ###
A = [0.012,0.012,0.130] # GHZ  
ge = [1.67,1.67,0.61] # electron g-factor TiO. Taken from Steinbrecher 2021

### Parameters to sweep ###
Q = -0.061
eta = 0
B_ext = 0.015
B_angle = 0
B_tip_angle = 8
B_tip = 0.030

# Convert lockin to number osf electron per pulse
# Parameters for conversion
lockinfreq = 270 # frequency of the lockin (Hz)
lockinsens = 0.100 # lockin sensitivity (V)
nbprobepulse = 6172# number of probe pulses
gain = 10**11 # gain of the current amplifier (I/V)
qel = 1.602*10**-19 # charge of an electron in Coulomb

####### Generate list of names at file location
listfiles = GenList([285,286],'../data/e-pulse/AWG_PP_{}.dat')
listfiles = GenList([300,299,296,298],'../data/e-pulse/AWG_PP_{}.dat')

npts = 600
x='Probe delay Tau2 (sec)'
y='Lock-In Y (V)'

#%%

fig, axs = plt.subplots(1,1,figsize=(6.4/1.2,4.8/1.2))   #figsize=(6.4*3/1.5,4.8/1.5))

### FIT TRACES WITH SINGLE OSCILLATION ###

# Select files
file = listfiles[0] #13

# Initial guesses
#       f,  T_1,T_2, A,   B,  C, phi
p0 = [[0.05,600,100,0.01,0.1,0.05,3],
      [0.05,600,100,0.01,0.1,0.05,3],
      [0.05,600,100,0.01,0.1,0.05,3],
      [0.05,600,100,0.005,0.1,0.05,0]
      ]

# Initialize
treated_swap_data = []
swap_current = []
colors = ['C0','C1','C2','C3']

for i,file in enumerate(listfiles):
    # Read files
    data, header = ReadFile_PP(file)
    currentstpt = round(float(header[1][12])*1e12,2)
    biasstpt = round(float(header[1][11])*1000)
    t = data[x][0:npts]*1e9
    trace = data[y][0:npts]
    
    # Convert y axis
    trace = LI_to_electrons(trace,lockinsens,gain,lockinfreq,nbprobepulse,qel)
    
    # Fit data
    # popt, pcov = curve_fit(Swapfit, t, trace, p0)
    popt, pcov = curve_fit(Swapfit, t, trace, p0[i])
    
    swapfit = Swapfit(t, *popt)
    
    # Plotting
    # im = axs[1].plot(t,swapfit,c='black')
    offset = 0.03
    if i == 1 :
        swapfit = swapfit + offset
        trace = trace + offset
        t = t+5
    if i == 2 :
        swapfit = swapfit + offset*2
        trace = trace + offset*2
        t = t+10
    if i == 3 :
        swapfit = swapfit + offset*3
        trace = trace + offset*3
        t = t+20
    labels = ['Without extra pulse','With extra pulse']
    labels = ['no 2nd pump','5 ns 2nd pump','10 ns 2nd pump','20 ns 2nd pump']

    im = axs.plot(t,swapfit,c=colors[i], label = labels[i])
    axs.plot(t,trace,c=colors[i],alpha=0.4,label = '_nolegend_')
    axs.set_xlabel('Free evolution time (ns)')
    axs.set_ylabel('# electrons per probe pulse')
    axs.set_ylim([0.015,0.33])
    axs.set_xlim([0,110])
    handles, labels = axs.get_legend_handles_labels()
    axs.legend(handles = handles[::-1], labels = labels[::-1],loc = 'upper right')

plt.savefig('../plots/second_pump.pdf')

