# -*- coding: utf-8 -*-
"""
Created on Wed Feb 22 15:53:26 2023

@author: lmveldman
"""


import os
import sys
import inspect

### IMPORTING MODULE FROM PARENT DIRECTORY
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
grandparentdir = os.path.dirname(parentdir)
sys.path.insert(0, grandparentdir) 

from data_analysis_functions import *

##############################################
############ FITTING REFERENCES ##############
##############################################

########### channels to extract
x = 'Frequency (Hz)'
y = 'Lock-In Y (V)'

########### initialize arrays for reference data and parameters
popt_ref = []
pcov_ref = []
freq_ref = []
data_ref = []

############ List of inital guesses: I_peak,  f_0,  Gamma,  A,  q
p0 = [ [0.12,12.1,0.1,0.02,2],
      [0.12,12,0.1,0.02,0],
      [0.12,12,0.1,0.02,0],
       [0.06,12.5,0.1,0.02,0],
      [0.12,12.3,0.1,0.02,0],
      [0.06,12.5,0.1,0.02,0],
      [0.12,12.4,0.1,0.02,0],
      [0.1,12.6,0.1,0.02,0],
     [0.1,12.4,0.1,0.02,0]]

############ enter files. Different selections are shown
files = ['ESR_725.tf','ESR_720.tf','ESR_728.tf','ESR_778.tf','ESR_783.tf','ESR_775.tf','ESR_755.tf','ESR_736.tf','ESR_762.tf']

########### offset traces in plot
offset = np.linspace(0,0.5,len(files))

########### import and read files
for i,name in enumerate(files):
    file = '../data/esr/reference/'+ name
    data, header = ReadFile_ESR(file)
    currentstpt = float(header[1][3])*1e12
    biasstpt = float(header[1][4])*1000

    ############ remove NaN values in x and y data
    ydat = np.array(data[y])[~np.isnan(np.array(data[y]))]
    xdat = np.array(data[x])[~np.isnan(np.array(data[x]))]
    
    ############# Convert axes to correct units
    freq = xdat*10**-9
    Delta_I = LItoA_ESR(ydat,0.05,10**11)
    
    ############# Fitting parameters:  I_peak,  f_0,  Gamma,  A,  q
    popt, pcov = curve_fit(Single_Fano, freq, Delta_I, p0=p0[i], bounds=((0.01, 11.9,0.01,-0.4,-2), (2,12.7,0.5,0.05,2)))
    
    ############# save all reference atom parameters in arrays
    popt_ref.append(popt)
    pcov_ref.append(pcov)
    freq_ref.append(freq)
    data_ref.append(Delta_I)
    
    ############ plotting for the fitting process
    plt.plot(freq, Single_Fano(freq, *popt)+offset[i], 'tab:blue', label='Fit: \n Ipeak=%5.3f, \n f0=%5.3f, \n FWHM=%5.3f, \n offset=%5.3f, \n q=%5.3f ' % tuple(popt))
    plt.plot(freq, Delta_I+offset[i],'o',c='tab:blue',alpha=0.5,markersize=2, label = file + '\n' + '{:.1f} pA, {:.1f} mV'.format(currentstpt,biasstpt)) 
    plt.xlabel('f - f\u2080 (GHz)')
    plt.ylabel('\u0394 I (pA)')

############# plotting for final graph
fig = plt.figure()
cmap = plt.cm.get_cmap('autumn')
for i in range(len(files)):
    plt.plot(freq_ref[i]-popt_ref[i][1], Single_Fano(freq_ref[i], *popt_ref[i])-popt_ref[i][3] + offset[i], c=cmap(i/len(files)), label='Fit: \n Ipeak=%5.3f, \n f0=%5.3f, \n FWHM=%5.3f, \n offset=%5.3f, \n q=%5.3f ' % tuple(popt))
    plt.plot(freq_ref[i]-popt_ref[i][1], data_ref[i]-popt_ref[i][3]+offset[i],'o',c=cmap(i/len(files)),alpha=0.3,markersize=2, label = file + '\n' + '{:.1f} pA, {:.1f} mV'.format(currentstpt,biasstpt)) 
plt.xlabel('f - f\u2080 (GHz)')
plt.ylabel('\u0394 I (pA)')
plt.tick_params(direction="in")
plt.legend(reversed(plt.legend().legendHandles),reversed(['100\u00B0','_nolegend_','90\u00B0','_nolegend_','80\u00B0','_nolegend_','60\u00B0','_nolegend_','45\u00B0','_nolegend_','30\u00B0','_nolegend_','10\u00B0','_nolegend_','0\u00B0','_nolegend_','-10\u00B0','_nolegend_']));


#%%

##############################################
############ FITTING HYPERFINES ##############
##############################################

########### channels to extract
x = 'Frequency (Hz)'
y = 'Lock-In Y (V)'

########### initialize arrays for reference data and parameters
popt_hyp = []
perror_hyp = []
freq_hyp = []
data_hyp = []

############ enter files
files = ['ESR_726.tf','ESR_721.tf','ESR_729.tf','ESR_780.tf','ESR_785.tf','ESR_774.tf','ESR_759.tf','ESR_734.tf','ESR_763.tf']

########### offset traces in plot
offset = np.linspace(0,0.15,len(files))

############ List of inital guesses:  f_0,Gamma,q,A,Delta_F,I_A,I_B,I_C,I_D,I_E,I_F
p0 = [ [popt_ref[0][1],popt_ref[0][2],popt_ref[0][4],popt_ref[0][3],0.13,popt_ref[0][0]/6,popt_ref[0][0]/6,popt_ref[0][0]/6,popt_ref[0][0]/6,popt_ref[0][0]/6,popt_ref[0][0]/6],
       [popt_ref[1][1],popt_ref[1][2],popt_ref[1][4],popt_ref[1][3],0.13,popt_ref[1][0]/6,popt_ref[1][0]/6,popt_ref[1][0]/6,popt_ref[1][0]/6,popt_ref[1][0]/6,popt_ref[1][0]/6],
      [popt_ref[2][1],popt_ref[2][2],popt_ref[2][4],popt_ref[2][3],0.12,popt_ref[2][0]/6,popt_ref[2][0]/6,popt_ref[2][0]/6,popt_ref[2][0]/6,popt_ref[2][0]/6,popt_ref[2][0]/6],
      [popt_ref[3][1],popt_ref[3][2],popt_ref[3][4],popt_ref[3][3],0.07,popt_ref[3][0]/6,popt_ref[3][0]/6,popt_ref[3][0]/6,popt_ref[3][0]/6,popt_ref[3][0]/6,popt_ref[3][0]/6],
       [popt_ref[4][1]-0.05,popt_ref[4][2],popt_ref[4][4],popt_ref[4][3],0.05,popt_ref[4][0]/6,popt_ref[4][0]/6,popt_ref[4][0]/6,popt_ref[4][0]/6,popt_ref[4][0]/6,popt_ref[4][0]/6],
      [popt_ref[5][1],popt_ref[5][2],popt_ref[5][4],popt_ref[5][3],0.03,popt_ref[5][0]/6,popt_ref[5][0]/6,popt_ref[5][0]/6,popt_ref[5][0]/6,popt_ref[5][0]/6,popt_ref[5][0]/6],
      [popt_ref[6][1],popt_ref[6][2],popt_ref[6][4],popt_ref[6][3],0.01,popt_ref[6][0]/6,popt_ref[6][0]/6,popt_ref[6][0]/6,popt_ref[6][0]/6,popt_ref[6][0]/6,popt_ref[6][0]/6],
      [popt_ref[7][1],popt_ref[7][2],popt_ref[7][4],popt_ref[7][3],0.01,popt_ref[7][0]/6,popt_ref[7][0]/6,popt_ref[7][0]/6,popt_ref[7][0]/6,popt_ref[7][0]/6,popt_ref[7][0]/6],
      [popt_ref[8][1]-0.05,popt_ref[8][2],popt_ref[8][4],popt_ref[8][3],0.01,popt_ref[8][0]/6,popt_ref[8][0]/6,popt_ref[8][0]/6,popt_ref[8][0]/6,popt_ref[8][0]/6,popt_ref[8][0]/6]
     ]
############ Fitting bounds
eps_Gamma = 0.01 # fitting bounds for widths
eps_I = 0.01 # fitting bound for Amplitudes
eps_q = 0.001 # fitting gbound for asymmetry
eps_A = 0.001 # fitting bound for offset
bounds = []
for i in range(len(files)):
    bounds.append(
     (
    (11.9,popt_ref[i][2]-eps_Gamma,popt_ref[i][4]-eps_q,popt_ref[i][3]-eps_A,0.005,popt_ref[i][0]/6-eps_I,popt_ref[i][0]/6-eps_I,popt_ref[i][0]/6-eps_I,popt_ref[i][0]/6-eps_I,popt_ref[i][0]/6-eps_I,popt_ref[i][0]/6-eps_I), 
    (12.8,popt_ref[i][2]+eps_Gamma,popt_ref[i][4]+eps_q,popt_ref[i][3]+eps_A,0.2,popt_ref[i][0]/6+eps_I,popt_ref[i][0]/6+eps_I,popt_ref[i][0]/6+eps_I,popt_ref[i][0]/6+eps_I,popt_ref[i][0]/6+eps_I,popt_ref[i][0]/6+eps_I)
     )
    )

for i,name in enumerate(files):
    ########### import and read files
    file = '../data/esr/hyperfine/'+ name
    data, header = ReadFile_ESR(file)
    currentstpt = float(header[1][3])*1e12
    biasstpt = float(header[1][4])*1000
    
    ############ remove NaN values in x and y data
    ydat = np.array(data[y])[~np.isnan(np.array(data[y]))]
    xdat = np.array(data[x])[~np.isnan(np.array(data[x]))]
    
    ############# Convert axes to correct units
    freq = xdat*10**-9
    Delta_I = LItoA_ESR(ydat,0.05,10**11)
    
    ############# Fitting parameters:  f,f_0,Gamma,q,A,Delta_F,I_A,I_B,I_C,I_D,I_E,I_F
    popt, pcov = curve_fit(Six_Fano, freq, Delta_I, p0=p0[i], bounds=bounds[i])
    
    ############# save all reference atom parameters in arrays
    popt_hyp.append(popt)
    perror_hyp.append(np.sqrt(np.diag(pcov)))
    freq_hyp.append(freq)
    data_hyp.append(Delta_I)
    
    ############ plotting for the fitting process
    plt.plot(freq, Six_Fano(freq, *popt)+offset[i], 'tab:blue')
    plt.plot(freq, Delta_I+offset[i],'o',c='tab:blue',alpha=0.5,markersize=2, label = file + '\n' + '{:.1f} pA, {:.1f} mV'.format(currentstpt,biasstpt)) 
    plt.xlabel('f - f\u2080 (GHz)')
    plt.ylabel('\u0394 I (pA)')

############# plotting for final graph
fig, ax1 = plt.subplots(figsize=(6.4/1.4,4.8/1.4))
cmap = plt.cm.get_cmap('autumn')

for i in [1,3,5,7]: # plot only selected files
    ax1.plot(freq_hyp[i]-popt_hyp[i][0], Six_Fano(freq_hyp[i], *popt_hyp[i])-popt_hyp[i][3] + offset[i], c=cmap(i/len(files)),label='bla')
    ax1.plot(freq_hyp[i]-popt_hyp[i][0], data_hyp[i]-popt_hyp[i][3]+offset[i],c=cmap(i/len(files)),alpha=0.5,label='bla') 
ax1.set_xlim([-0.65,0.75])
ax1.set_xlabel('f - f\u2080 (GHz)')
ax1.set_ylabel('\u0394 I (pA)')
ax1.tick_params(direction="in")
labels = ['100\u00B0','_nolegend_','90\u00B0','_nolegend_','80\u00B0','_nolegend_','60\u00B0','_nolegend_','45\u00B0','_nolegend_','30\u00B0','_nolegend_','10\u00B0','_nolegend_','0\u00B0','_nolegend_','-10\u00B0','_nolegend_']
ax1.legend(reversed(plt.legend().legendHandles),reversed(labels[2:4]+labels[6:8]+labels[10:12]+labels[14:16]),loc='upper left');

### Inset figure
# These are in unitless percentages of the figure size. (0,0 is bottom left)
left, bottom, width, height = [0.81, 0.69, 0.15, 0.25]
ax2 = fig.add_axes([left, bottom, width, height])

splitting = []
for i in range(len(files)):
    print(popt_hyp[i][4])
    splitting.append(popt_hyp[i][4]*1000) # append and convert to MHz 
angles = [100,90,80,60,45,30,10,0,-10]
ax2.errorbar(angles, splitting, yerr=np.transpose(perror_hyp)[4]*1000,fmt=".",markersize='5')
ax2.set_xlabel('Angle (\u00B0)')
ax2.set_ylabel('|A| (MHz)')
ax2.set_xticks([0,90])
ax2.set_yticks([0,30,60,90,120])
ax2.tick_params(direction="in")
plt.tight_layout()
plt.savefig('../plots/hyperfine_anisotropy.pdf')







