# -*- coding: utf-8 -*-
"""
Created on Thu Feb 23 14:44:06 2023

@author: lmveldman
"""


import os
import sys
import inspect

### IMPORTING MODULE FROM PARENT DIRECTORY
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
grandparentdir = os.path.dirname(parentdir)
sys.path.insert(0, grandparentdir) 

from data_analysis_functions import *

##################################
########## First dataset #########
##################################

####### Generate list of names at file location
listfiles = GenList([702,701,700,699]+list(range(686,699)),'../data/different_tip_40mt/ESR_{}.tf')
npts = 1485

# Channels to plot
x='Frequency (Hz)'
y='Lock-In Y (V)'

bias = []
conductance = []
z = np.zeros(npts)

for file in listfiles:
    # import data
    data, header = ReadFile_ESR(file)
    currentstpt = round(float(header[1][3])*1e12) # in pA
    biasstpt = round(float(header[1][4]),4) # in V
    freq = data[x][0:npts]*1e-9
    trace = data[y][0:npts]
    
    # Normalise
    # trace = Normalise(trace)
    
    # substract average value from trace
    trace = trace - (sum(trace)/npts)
    
    z = np.column_stack((z,trace))
    bias.append(biasstpt)
    conductance.append(currentstpt/biasstpt)
z = np.delete(z, 0, 1) #delete row of zeros from initialization

colors = 'magma_r'


fig, axs = plt.subplots(2,1,figsize=(5,7), gridspec_kw={'height_ratios': [1, 1]})

# plt.figure(figsize=(6.4,4.8))
bias = [1/entry for entry in bias]
im = axs[0].pcolor(conductance,freq*1000,z, cmap=colors,vmin=z.min(),vmax=z.max()/1.5)
axs[0].set_xlabel('Conductance (pS)')
axs[0].set_ylabel('Frequency (MHz)')
cbar = fig.colorbar(im,ax=axs[0],aspect=40)
cbar.set_label('ESR signal (a.u.)')
fig.tight_layout()


################################
########## Second dataset ######
################################
    
####### Generate list of names at file location
listfiles = GenList(range(710,727),'../data/different_tip_25mt/ESR_{}.tf')
npts = 1459
start = 0
x='Frequency (Hz)'
y='Lock-In Y (V)'


bias = []
conductance = []
z_zoom = np.zeros(npts-start)

for file in listfiles:
    data, header = ReadFile_ESR(file)
    currentstpt = round(float(header[1][3])*1e12)
    biasstpt = round(float(header[1][4]),4)
    freq = data[x][start:npts]*1e-9
    trace = data[y][start:npts]
    
    # Normalise
    # trace = Normalise(trace)

    # substract average value from trace
    trace = trace - (sum(trace)/npts)
    
    z_zoom = np.column_stack((z_zoom,trace))
    bias.append(biasstpt)
    conductance.append(currentstpt/biasstpt)
z_zoom = np.delete(z_zoom, 0, 1) #delete row of zeros from initialization

bias = [1/entry for entry in bias]
im2 = axs[1].pcolor(conductance,freq*1000,z_zoom, cmap=colors,vmin=z_zoom.min(),vmax=z_zoom.max())
axs[1].set_xlabel('Conductance (pS)')
axs[1].set_ylabel('Frequency (MHz)')
cbar = fig.colorbar(im2,ax=axs[1],aspect=20)
cbar.set_label('ESR signal (a.u.)')
axs[1].tick_params(direction="in")
fig.tight_layout()
plt.savefig('../plots/different_tip_data.pdf')

