# -*- coding: utf-8 -*-
"""
Created on Mon Feb 27 11:53:58 2023

@author: lmveldman
"""

import os
import sys
import inspect

### CHANGING TO CORRECT DIRECTORY
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
grandparentdir = os.path.dirname(parentdir)
sys.path.insert(0, grandparentdir) 

from data_analysis_functions import *

# Convert lockin to number of electron per pulse
# Parameters for conversion
lockinfreq = 270 # frequency of the lockin (Hz)
lockinsens = 0.100 # lockin sensitivity (V)
nbprobepulse = 6172# number of probe pulses
gain = 10**11 # gain of the current amplifier (I/V)
qel = 1.602*10**-19 # charge of an electron in Coulomb

####### Generate list of names at file location
listfiles = GenList([325,324,323,322,312,311,310,309,308,313,314,315,316,317,318,319,320,321],'../data/AWG_PP_{}.dat')
npts = 600
x='Probe delay Tau2 (sec)'
y='Lock-In Y (V)'

#%%
###  FIT WITH SINGLE OSCILLATION ###


fig, ax = plt.subplots(1,1,figsize=(6.4*1.5/2,4.8/2))

# Select files
file = listfiles[13] #13

# Initial guesses
#       f,  T_1,T_2, A,   B,  C, phi
p0 = [[0.05,600,100,0.01,0.1,0.05,3]]

# Initialize
treated_swap_data = []
swap_current = []

# Read files
data, header = ReadFile_PP(file)
currentstpt = round(float(header[1][12])*1e12,2)
print(currentstpt)
biasstpt = round(float(header[1][11])*1000)
t = data[x][0:npts]*1e9
trace = data[y][0:npts]

# Convert y axis
trace = LI_to_electrons(trace,lockinsens,gain,lockinfreq,nbprobepulse,qel)

# Fit data
# popt, pcov = curve_fit(Swapfit, t, trace, p0)
popt, pcov = curve_fit(Swapfit, t, trace, p0)

swapfit = Swapfit(t, *popt)

# Plotting
# im = axs[1].plot(t,swapfit,c='black')
im = ax.plot(t,trace,c='grey')
ax.plot(t,swapfit,c='black')
ax.set_xlabel('Time (ns)')
ax.set_ylabel('# electrons per probe pulse')
ax.text(110, 0.09, r'$f_{1}=$'+'{} MHz \n'.format(round(popt[0]*1000,1)),
            verticalalignment='top')
fig.tight_layout()
plt.savefig('../plots/fig_4b.pdf')


#%%
### FIT WIIT MULTIPLE OSCILAATIONS

fig, ax = plt.subplots(1,1,figsize=(6.4*1.5/2,4.8/2))

# Select files
file = listfiles[8]

# Initial guess
#       f,   T_1,  T_2,  A,    B,     C,   phi,  f_n,  T_2_n,  B_n,   phi_n   D
p0 = [0.065, 2000, 100, 0.02, 0.02, -0.03,  5,  0.025,  90,    0.02,   2,    0.06]

# Fitting bounds
#              f,   T_1,  T_2,    A,    B,     C,   phi, f_n,  T_2_n,  B_n,   phi_n   D
bounds_vec = [0.02, 3000, 200,  0.15,  0.5,   0.1,  10,  0.01,  1000,  0.05,   10,  0.05]

# Generate upper and lower bounds
lower = np.zeros(len(bounds_vec))
upper = np.zeros(len(bounds_vec))
bounds = []
for j,bound in enumerate(bounds_vec):
    lower[j] = p0[j]-bound
    upper[j] = p0[j]+bound
bounds.append(tuple((np.array(lower),np.array(upper))))

# Initialize
treated_hyperswap_data = []
hyperswap_current = []

# Read files
data, header = ReadFile_PP(file)
currentstpt = round(float(header[1][12])*1e12,2)
print(currentstpt)
biasstpt = round(float(header[1][11])*1000)
t = data[x][0:npts]*1e9
trace = data[y][0:npts]

# Fitting
popt, pcov = curve_fit(Hyperswapfit, t, trace, p0, bounds=bounds[0])
swapfit = Hyperswapfit(t, *popt)

#Plotting
im = ax.plot(t,trace,c='grey') 
ax.plot(t,swapfit,c='black')
ax.set_xlabel('Time (ns)')
ax.set_ylabel('# electrons per probe pulse')
ax.text(110, 0.09, r'$f_{1}=$'+'{} MHz \n'.format(round(popt[0]*1000,1)) + r'$f_{2}=$'+'{} MHz'.format(round(popt[7]*1000,1)),
            verticalalignment='top')
fig.tight_layout()
plt.savefig('../plots/fig_4c.pdf')

print('T2: ',popt[2], popt[8])
print('freq: ',popt[0]*1000, popt[7]*1000, popt[11]*1000)
print('Amplitude: ',popt[4],popt[9])

print('60 MHz amplitude:',popt[4])
print('20 MHz amplitude:',popt[9])
print('80 MHz amplitude:',popt[11])
